/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the most recent server-side encryption configuration update. When the server-side encryption
 * configuration is changed, dependency on the old KMS key is removed through an asynchronous process. When this update
 * is complete, the domain’s data can only be accessed using the new KMS key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerSideEncryptionUpdateDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerSideEncryptionUpdateDetails.Builder, ServerSideEncryptionUpdateDetails> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ServerSideEncryptionUpdateDetails::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> OLD_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OldKmsKeyId").getter(getter(ServerSideEncryptionUpdateDetails::oldKmsKeyId))
            .setter(setter(Builder::oldKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldKmsKeyId").build()).build();

    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateStatus").getter(getter(ServerSideEncryptionUpdateDetails::updateStatusAsString))
            .setter(setter(Builder::updateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD,
            OLD_KMS_KEY_ID_FIELD, UPDATE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String oldKmsKeyId;

    private final String updateStatus;

    private ServerSideEncryptionUpdateDetails(BuilderImpl builder) {
        this.message = builder.message;
        this.oldKmsKeyId = builder.oldKmsKeyId;
        this.updateStatus = builder.updateStatus;
    }

    /**
     * <p>
     * Message explaining the current UpdateStatus. When the UpdateStatus is FAILED, this message explains the cause of
     * the failure.
     * </p>
     * 
     * @return Message explaining the current UpdateStatus. When the UpdateStatus is FAILED, this message explains the
     *         cause of the failure.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The previous KMS key ID the domain was encrypted with, before ServerSideEncryptionConfiguration was updated to a
     * new KMS key ID.
     * </p>
     * 
     * @return The previous KMS key ID the domain was encrypted with, before ServerSideEncryptionConfiguration was
     *         updated to a new KMS key ID.
     */
    public final String oldKmsKeyId() {
        return oldKmsKeyId;
    }

    /**
     * <p>
     * Status of the server-side encryption update. During an update, if there is an issue with the domain's current or
     * old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In order to resolve this, the
     * key needs to be made accessible, and then an UpdateDomain call with the existing server-side encryption
     * configuration will re-attempt this update process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link ServerSideEncryptionUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return Status of the server-side encryption update. During an update, if there is an issue with the domain's
     *         current or old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In order
     *         to resolve this, the key needs to be made accessible, and then an UpdateDomain call with the existing
     *         server-side encryption configuration will re-attempt this update process.
     * @see ServerSideEncryptionUpdateStatus
     */
    public final ServerSideEncryptionUpdateStatus updateStatus() {
        return ServerSideEncryptionUpdateStatus.fromValue(updateStatus);
    }

    /**
     * <p>
     * Status of the server-side encryption update. During an update, if there is an issue with the domain's current or
     * old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In order to resolve this, the
     * key needs to be made accessible, and then an UpdateDomain call with the existing server-side encryption
     * configuration will re-attempt this update process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link ServerSideEncryptionUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return Status of the server-side encryption update. During an update, if there is an issue with the domain's
     *         current or old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In order
     *         to resolve this, the key needs to be made accessible, and then an UpdateDomain call with the existing
     *         server-side encryption configuration will re-attempt this update process.
     * @see ServerSideEncryptionUpdateStatus
     */
    public final String updateStatusAsString() {
        return updateStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(oldKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerSideEncryptionUpdateDetails)) {
            return false;
        }
        ServerSideEncryptionUpdateDetails other = (ServerSideEncryptionUpdateDetails) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(oldKmsKeyId(), other.oldKmsKeyId())
                && Objects.equals(updateStatusAsString(), other.updateStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerSideEncryptionUpdateDetails").add("Message", message()).add("OldKmsKeyId", oldKmsKeyId())
                .add("UpdateStatus", updateStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "OldKmsKeyId":
            return Optional.ofNullable(clazz.cast(oldKmsKeyId()));
        case "UpdateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Message", MESSAGE_FIELD);
        map.put("OldKmsKeyId", OLD_KMS_KEY_ID_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerSideEncryptionUpdateDetails, T> g) {
        return obj -> g.apply((ServerSideEncryptionUpdateDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerSideEncryptionUpdateDetails> {
        /**
         * <p>
         * Message explaining the current UpdateStatus. When the UpdateStatus is FAILED, this message explains the cause
         * of the failure.
         * </p>
         * 
         * @param message
         *        Message explaining the current UpdateStatus. When the UpdateStatus is FAILED, this message explains
         *        the cause of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The previous KMS key ID the domain was encrypted with, before ServerSideEncryptionConfiguration was updated
         * to a new KMS key ID.
         * </p>
         * 
         * @param oldKmsKeyId
         *        The previous KMS key ID the domain was encrypted with, before ServerSideEncryptionConfiguration was
         *        updated to a new KMS key ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldKmsKeyId(String oldKmsKeyId);

        /**
         * <p>
         * Status of the server-side encryption update. During an update, if there is an issue with the domain's current
         * or old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In order to resolve
         * this, the key needs to be made accessible, and then an UpdateDomain call with the existing server-side
         * encryption configuration will re-attempt this update process.
         * </p>
         * 
         * @param updateStatus
         *        Status of the server-side encryption update. During an update, if there is an issue with the domain's
         *        current or old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In
         *        order to resolve this, the key needs to be made accessible, and then an UpdateDomain call with the
         *        existing server-side encryption configuration will re-attempt this update process.
         * @see ServerSideEncryptionUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryptionUpdateStatus
         */
        Builder updateStatus(String updateStatus);

        /**
         * <p>
         * Status of the server-side encryption update. During an update, if there is an issue with the domain's current
         * or old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In order to resolve
         * this, the key needs to be made accessible, and then an UpdateDomain call with the existing server-side
         * encryption configuration will re-attempt this update process.
         * </p>
         * 
         * @param updateStatus
         *        Status of the server-side encryption update. During an update, if there is an issue with the domain's
         *        current or old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In
         *        order to resolve this, the key needs to be made accessible, and then an UpdateDomain call with the
         *        existing server-side encryption configuration will re-attempt this update process.
         * @see ServerSideEncryptionUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerSideEncryptionUpdateStatus
         */
        Builder updateStatus(ServerSideEncryptionUpdateStatus updateStatus);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String oldKmsKeyId;

        private String updateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerSideEncryptionUpdateDetails model) {
            message(model.message);
            oldKmsKeyId(model.oldKmsKeyId);
            updateStatus(model.updateStatus);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getOldKmsKeyId() {
            return oldKmsKeyId;
        }

        public final void setOldKmsKeyId(String oldKmsKeyId) {
            this.oldKmsKeyId = oldKmsKeyId;
        }

        @Override
        public final Builder oldKmsKeyId(String oldKmsKeyId) {
            this.oldKmsKeyId = oldKmsKeyId;
            return this;
        }

        public final String getUpdateStatus() {
            return updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(ServerSideEncryptionUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        @Override
        public ServerSideEncryptionUpdateDetails build() {
            return new ServerSideEncryptionUpdateDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
