/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request failed due to a conflict. Check the <code>ConflictType</code> and error message for more details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictException extends VoiceIdException implements
        ToCopyableBuilder<ConflictException.Builder, ConflictException> {
    private static final SdkField<String> CONFLICT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConflictType").getter(getter(ConflictException::conflictTypeAsString))
            .setter(setter(Builder::conflictType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String conflictType;

    private ConflictException(BuilderImpl builder) {
        super(builder);
        this.conflictType = builder.conflictType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The type of conflict which caused a ConflictException. Possible types and the corresponding error messages are as
     * follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment has
     * been requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by another
     * request during execution.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conflictType} will
     * return {@link ConflictType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conflictTypeAsString}.
     * </p>
     * 
     * @return The type of conflict which caused a ConflictException. Possible types and the corresponding error
     *         messages are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment
     *         has been requested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by
     *         another request during execution.
     *         </p>
     *         </li>
     * @see ConflictType
     */
    public ConflictType conflictType() {
        return ConflictType.fromValue(conflictType);
    }

    /**
     * <p>
     * The type of conflict which caused a ConflictException. Possible types and the corresponding error messages are as
     * follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment has
     * been requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by another
     * request during execution.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conflictType} will
     * return {@link ConflictType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conflictTypeAsString}.
     * </p>
     * 
     * @return The type of conflict which caused a ConflictException. Possible types and the corresponding error
     *         messages are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment
     *         has been requested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by
     *         another request during execution.
     *         </p>
     *         </li>
     * @see ConflictType
     */
    public String conflictTypeAsString() {
        return conflictType;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConflictType", CONFLICT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConflictException, T> g) {
        return obj -> g.apply((ConflictException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictException>, VoiceIdException.Builder {
        /**
         * <p>
         * The type of conflict which caused a ConflictException. Possible types and the corresponding error messages
         * are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment has
         * been requested.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by another
         * request during execution.
         * </p>
         * </li>
         * </ul>
         * 
         * @param conflictType
         *        The type of conflict which caused a ConflictException. Possible types and the corresponding error
         *        messages are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an
         *        enrollment has been requested.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by
         *        another request during execution.
         *        </p>
         *        </li>
         * @see ConflictType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictType
         */
        Builder conflictType(String conflictType);

        /**
         * <p>
         * The type of conflict which caused a ConflictException. Possible types and the corresponding error messages
         * are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment has
         * been requested.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by another
         * request during execution.
         * </p>
         * </li>
         * </ul>
         * 
         * @param conflictType
         *        The type of conflict which caused a ConflictException. Possible types and the corresponding error
         *        messages are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an
         *        enrollment has been requested.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by
         *        another request during execution.
         *        </p>
         *        </li>
         * @see ConflictType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictType
         */
        Builder conflictType(ConflictType conflictType);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends VoiceIdException.BuilderImpl implements Builder {
        private String conflictType;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictException model) {
            super(model);
            conflictType(model.conflictType);
        }

        public final String getConflictType() {
            return conflictType;
        }

        public final void setConflictType(String conflictType) {
            this.conflictType = conflictType;
        }

        @Override
        public final Builder conflictType(String conflictType) {
            this.conflictType = conflictType;
            return this;
        }

        @Override
        public final Builder conflictType(ConflictType conflictType) {
            this.conflictType(conflictType == null ? null : conflictType.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ConflictException build() {
            return new ConflictException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
