/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.voiceid.model.SpeakerSummariesCopier;
import software.amazon.awssdk.services.voiceid.model.SpeakerSummary;
import software.amazon.awssdk.services.voiceid.model.VoiceIdResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSpeakersResponse
extends VoiceIdResponse
implements ToCopyableBuilder<Builder, ListSpeakersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSpeakersResponse.getter(ListSpeakersResponse::nextToken)).setter(ListSpeakersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SpeakerSummary>> SPEAKER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpeakerSummaries").getter(ListSpeakersResponse.getter(ListSpeakersResponse::speakerSummaries)).setter(ListSpeakersResponse.setter(Builder::speakerSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeakerSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpeakerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SPEAKER_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSpeakersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SpeakerSummary> speakerSummaries;

    private ListSpeakersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.speakerSummaries = builder.speakerSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSpeakerSummaries() {
        return this.speakerSummaries != null && !(this.speakerSummaries instanceof SdkAutoConstructList);
    }

    public final List<SpeakerSummary> speakerSummaries() {
        return this.speakerSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpeakerSummaries() ? this.speakerSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSpeakersResponse)) {
            return false;
        }
        ListSpeakersResponse other = (ListSpeakersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSpeakerSummaries() == other.hasSpeakerSummaries() && Objects.equals(this.speakerSummaries(), other.speakerSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListSpeakersResponse").add("NextToken", (Object)this.nextToken()).add("SpeakerSummaries", this.hasSpeakerSummaries() ? this.speakerSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SpeakerSummaries": {
                return Optional.ofNullable(clazz.cast(this.speakerSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SpeakerSummaries", SPEAKER_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSpeakersResponse, T> g) {
        return obj -> g.apply((ListSpeakersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VoiceIdResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SpeakerSummary> speakerSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSpeakersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.speakerSummaries(model.speakerSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SpeakerSummary.Builder> getSpeakerSummaries() {
            List<SpeakerSummary.Builder> result = SpeakerSummariesCopier.copyToBuilder(this.speakerSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpeakerSummaries(Collection<SpeakerSummary.BuilderImpl> speakerSummaries) {
            this.speakerSummaries = SpeakerSummariesCopier.copyFromBuilder(speakerSummaries);
        }

        @Override
        public final Builder speakerSummaries(Collection<SpeakerSummary> speakerSummaries) {
            this.speakerSummaries = SpeakerSummariesCopier.copy(speakerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speakerSummaries(SpeakerSummary ... speakerSummaries) {
            this.speakerSummaries(Arrays.asList(speakerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speakerSummaries(Consumer<SpeakerSummary.Builder> ... speakerSummaries) {
            this.speakerSummaries(Stream.of(speakerSummaries).map(c -> (SpeakerSummary)((SpeakerSummary.Builder)SpeakerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSpeakersResponse build() {
            return new ListSpeakersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VoiceIdResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSpeakersResponse> {
        public Builder nextToken(String var1);

        public Builder speakerSummaries(Collection<SpeakerSummary> var1);

        public Builder speakerSummaries(SpeakerSummary ... var1);

        public Builder speakerSummaries(Consumer<SpeakerSummary.Builder> ... var1);
    }
}

