/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.AuthenticationResult;
import software.amazon.awssdk.services.voiceid.model.FraudDetectionResult;
import software.amazon.awssdk.services.voiceid.model.StreamingStatus;
import software.amazon.awssdk.services.voiceid.model.VoiceIdResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateSessionResponse
extends VoiceIdResponse
implements ToCopyableBuilder<Builder, EvaluateSessionResponse> {
    private static final SdkField<AuthenticationResult> AUTHENTICATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationResult").getter(EvaluateSessionResponse.getter(EvaluateSessionResponse::authenticationResult)).setter(EvaluateSessionResponse.setter(Builder::authenticationResult)).constructor(AuthenticationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationResult").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(EvaluateSessionResponse.getter(EvaluateSessionResponse::domainId)).setter(EvaluateSessionResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<FraudDetectionResult> FRAUD_DETECTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FraudDetectionResult").getter(EvaluateSessionResponse.getter(EvaluateSessionResponse::fraudDetectionResult)).setter(EvaluateSessionResponse.setter(Builder::fraudDetectionResult)).constructor(FraudDetectionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FraudDetectionResult").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(EvaluateSessionResponse.getter(EvaluateSessionResponse::sessionId)).setter(EvaluateSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionName").getter(EvaluateSessionResponse.getter(EvaluateSessionResponse::sessionName)).setter(EvaluateSessionResponse.setter(Builder::sessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionName").build()}).build();
    private static final SdkField<String> STREAMING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamingStatus").getter(EvaluateSessionResponse.getter(EvaluateSessionResponse::streamingStatusAsString)).setter(EvaluateSessionResponse.setter(Builder::streamingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_RESULT_FIELD, DOMAIN_ID_FIELD, FRAUD_DETECTION_RESULT_FIELD, SESSION_ID_FIELD, SESSION_NAME_FIELD, STREAMING_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluateSessionResponse.memberNameToFieldInitializer();
    private final AuthenticationResult authenticationResult;
    private final String domainId;
    private final FraudDetectionResult fraudDetectionResult;
    private final String sessionId;
    private final String sessionName;
    private final String streamingStatus;

    private EvaluateSessionResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationResult = builder.authenticationResult;
        this.domainId = builder.domainId;
        this.fraudDetectionResult = builder.fraudDetectionResult;
        this.sessionId = builder.sessionId;
        this.sessionName = builder.sessionName;
        this.streamingStatus = builder.streamingStatus;
    }

    public final AuthenticationResult authenticationResult() {
        return this.authenticationResult;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final FraudDetectionResult fraudDetectionResult() {
        return this.fraudDetectionResult;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String sessionName() {
        return this.sessionName;
    }

    public final StreamingStatus streamingStatus() {
        return StreamingStatus.fromValue(this.streamingStatus);
    }

    public final String streamingStatusAsString() {
        return this.streamingStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fraudDetectionResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateSessionResponse)) {
            return false;
        }
        EvaluateSessionResponse other = (EvaluateSessionResponse)((Object)obj);
        return Objects.equals(this.authenticationResult(), other.authenticationResult()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.fraudDetectionResult(), other.fraudDetectionResult()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionName(), other.sessionName()) && Objects.equals(this.streamingStatusAsString(), other.streamingStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateSessionResponse").add("AuthenticationResult", (Object)this.authenticationResult()).add("DomainId", (Object)this.domainId()).add("FraudDetectionResult", (Object)this.fraudDetectionResult()).add("SessionId", (Object)this.sessionId()).add("SessionName", (Object)this.sessionName()).add("StreamingStatus", (Object)this.streamingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationResult": {
                return Optional.ofNullable(clazz.cast(this.authenticationResult()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "FraudDetectionResult": {
                return Optional.ofNullable(clazz.cast(this.fraudDetectionResult()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "SessionName": {
                return Optional.ofNullable(clazz.cast(this.sessionName()));
            }
            case "StreamingStatus": {
                return Optional.ofNullable(clazz.cast(this.streamingStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthenticationResult", AUTHENTICATION_RESULT_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("FraudDetectionResult", FRAUD_DETECTION_RESULT_FIELD);
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("SessionName", SESSION_NAME_FIELD);
        map.put("StreamingStatus", STREAMING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateSessionResponse, T> g) {
        return obj -> g.apply((EvaluateSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VoiceIdResponse.BuilderImpl
    implements Builder {
        private AuthenticationResult authenticationResult;
        private String domainId;
        private FraudDetectionResult fraudDetectionResult;
        private String sessionId;
        private String sessionName;
        private String streamingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateSessionResponse model) {
            super(model);
            this.authenticationResult(model.authenticationResult);
            this.domainId(model.domainId);
            this.fraudDetectionResult(model.fraudDetectionResult);
            this.sessionId(model.sessionId);
            this.sessionName(model.sessionName);
            this.streamingStatus(model.streamingStatus);
        }

        public final AuthenticationResult.Builder getAuthenticationResult() {
            return this.authenticationResult != null ? this.authenticationResult.toBuilder() : null;
        }

        public final void setAuthenticationResult(AuthenticationResult.BuilderImpl authenticationResult) {
            this.authenticationResult = authenticationResult != null ? authenticationResult.build() : null;
        }

        @Override
        public final Builder authenticationResult(AuthenticationResult authenticationResult) {
            this.authenticationResult = authenticationResult;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final FraudDetectionResult.Builder getFraudDetectionResult() {
            return this.fraudDetectionResult != null ? this.fraudDetectionResult.toBuilder() : null;
        }

        public final void setFraudDetectionResult(FraudDetectionResult.BuilderImpl fraudDetectionResult) {
            this.fraudDetectionResult = fraudDetectionResult != null ? fraudDetectionResult.build() : null;
        }

        @Override
        public final Builder fraudDetectionResult(FraudDetectionResult fraudDetectionResult) {
            this.fraudDetectionResult = fraudDetectionResult;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionName() {
            return this.sessionName;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        @Override
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final String getStreamingStatus() {
            return this.streamingStatus;
        }

        public final void setStreamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
        }

        @Override
        public final Builder streamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
            return this;
        }

        @Override
        public final Builder streamingStatus(StreamingStatus streamingStatus) {
            this.streamingStatus(streamingStatus == null ? null : streamingStatus.toString());
            return this;
        }

        @Override
        public EvaluateSessionResponse build() {
            return new EvaluateSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VoiceIdResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvaluateSessionResponse> {
        public Builder authenticationResult(AuthenticationResult var1);

        default public Builder authenticationResult(Consumer<AuthenticationResult.Builder> authenticationResult) {
            return this.authenticationResult((AuthenticationResult)((AuthenticationResult.Builder)AuthenticationResult.builder().applyMutation(authenticationResult)).build());
        }

        public Builder domainId(String var1);

        public Builder fraudDetectionResult(FraudDetectionResult var1);

        default public Builder fraudDetectionResult(Consumer<FraudDetectionResult.Builder> fraudDetectionResult) {
            return this.fraudDetectionResult((FraudDetectionResult)((FraudDetectionResult.Builder)FraudDetectionResult.builder().applyMutation(fraudDetectionResult)).build());
        }

        public Builder sessionId(String var1);

        public Builder sessionName(String var1);

        public Builder streamingStatus(String var1);

        public Builder streamingStatus(StreamingStatus var1);
    }
}

