/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SpeakerStatus {
    ENROLLED("ENROLLED"),
    EXPIRED("EXPIRED"),
    OPTED_OUT("OPTED_OUT"),
    PENDING("PENDING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SpeakerStatus> VALUE_MAP;
    private final String value;

    private SpeakerStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpeakerStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpeakerStatus> knownValues() {
        EnumSet<SpeakerStatus> knownValues = EnumSet.allOf(SpeakerStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SpeakerStatus.class, SpeakerStatus::toString);
    }
}

