/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.EnrollmentConfig;
import software.amazon.awssdk.services.voiceid.model.InputDataConfig;
import software.amazon.awssdk.services.voiceid.model.OutputDataConfig;
import software.amazon.awssdk.services.voiceid.model.VoiceIdRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSpeakerEnrollmentJobRequest
extends VoiceIdRequest
implements ToCopyableBuilder<Builder, StartSpeakerEnrollmentJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartSpeakerEnrollmentJobRequest.getter(StartSpeakerEnrollmentJobRequest::clientToken)).setter(StartSpeakerEnrollmentJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(StartSpeakerEnrollmentJobRequest.getter(StartSpeakerEnrollmentJobRequest::dataAccessRoleArn)).setter(StartSpeakerEnrollmentJobRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(StartSpeakerEnrollmentJobRequest.getter(StartSpeakerEnrollmentJobRequest::domainId)).setter(StartSpeakerEnrollmentJobRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<EnrollmentConfig> ENROLLMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnrollmentConfig").getter(StartSpeakerEnrollmentJobRequest.getter(StartSpeakerEnrollmentJobRequest::enrollmentConfig)).setter(StartSpeakerEnrollmentJobRequest.setter(Builder::enrollmentConfig)).constructor(EnrollmentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentConfig").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(StartSpeakerEnrollmentJobRequest.getter(StartSpeakerEnrollmentJobRequest::inputDataConfig)).setter(StartSpeakerEnrollmentJobRequest.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(StartSpeakerEnrollmentJobRequest.getter(StartSpeakerEnrollmentJobRequest::jobName)).setter(StartSpeakerEnrollmentJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(StartSpeakerEnrollmentJobRequest.getter(StartSpeakerEnrollmentJobRequest::outputDataConfig)).setter(StartSpeakerEnrollmentJobRequest.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, DOMAIN_ID_FIELD, ENROLLMENT_CONFIG_FIELD, INPUT_DATA_CONFIG_FIELD, JOB_NAME_FIELD, OUTPUT_DATA_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartSpeakerEnrollmentJobRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String dataAccessRoleArn;
    private final String domainId;
    private final EnrollmentConfig enrollmentConfig;
    private final InputDataConfig inputDataConfig;
    private final String jobName;
    private final OutputDataConfig outputDataConfig;

    private StartSpeakerEnrollmentJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.domainId = builder.domainId;
        this.enrollmentConfig = builder.enrollmentConfig;
        this.inputDataConfig = builder.inputDataConfig;
        this.jobName = builder.jobName;
        this.outputDataConfig = builder.outputDataConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final EnrollmentConfig enrollmentConfig() {
        return this.enrollmentConfig;
    }

    public final InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrollmentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSpeakerEnrollmentJobRequest)) {
            return false;
        }
        StartSpeakerEnrollmentJobRequest other = (StartSpeakerEnrollmentJobRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.enrollmentConfig(), other.enrollmentConfig()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig());
    }

    public final String toString() {
        return ToString.builder((String)"StartSpeakerEnrollmentJobRequest").add("ClientToken", (Object)this.clientToken()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("DomainId", (Object)this.domainId()).add("EnrollmentConfig", (Object)this.enrollmentConfig()).add("InputDataConfig", (Object)this.inputDataConfig()).add("JobName", (Object)(this.jobName() == null ? null : "*** Sensitive Data Redacted ***")).add("OutputDataConfig", (Object)this.outputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "EnrollmentConfig": {
                return Optional.ofNullable(clazz.cast(this.enrollmentConfig()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("EnrollmentConfig", ENROLLMENT_CONFIG_FIELD);
        map.put("InputDataConfig", INPUT_DATA_CONFIG_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("OutputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSpeakerEnrollmentJobRequest, T> g) {
        return obj -> g.apply((StartSpeakerEnrollmentJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VoiceIdRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String dataAccessRoleArn;
        private String domainId;
        private EnrollmentConfig enrollmentConfig;
        private InputDataConfig inputDataConfig;
        private String jobName;
        private OutputDataConfig outputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSpeakerEnrollmentJobRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.domainId(model.domainId);
            this.enrollmentConfig(model.enrollmentConfig);
            this.inputDataConfig(model.inputDataConfig);
            this.jobName(model.jobName);
            this.outputDataConfig(model.outputDataConfig);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final EnrollmentConfig.Builder getEnrollmentConfig() {
            return this.enrollmentConfig != null ? this.enrollmentConfig.toBuilder() : null;
        }

        public final void setEnrollmentConfig(EnrollmentConfig.BuilderImpl enrollmentConfig) {
            this.enrollmentConfig = enrollmentConfig != null ? enrollmentConfig.build() : null;
        }

        @Override
        public final Builder enrollmentConfig(EnrollmentConfig enrollmentConfig) {
            this.enrollmentConfig = enrollmentConfig;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSpeakerEnrollmentJobRequest build() {
            return new StartSpeakerEnrollmentJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VoiceIdRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSpeakerEnrollmentJobRequest> {
        public Builder clientToken(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder domainId(String var1);

        public Builder enrollmentConfig(EnrollmentConfig var1);

        default public Builder enrollmentConfig(Consumer<EnrollmentConfig.Builder> enrollmentConfig) {
            return this.enrollmentConfig((EnrollmentConfig)((EnrollmentConfig.Builder)EnrollmentConfig.builder().applyMutation(enrollmentConfig)).build());
        }

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder jobName(String var1);

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

