/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.voiceid.model.FraudsterRegistrationJobSummariesCopier;
import software.amazon.awssdk.services.voiceid.model.FraudsterRegistrationJobSummary;
import software.amazon.awssdk.services.voiceid.model.VoiceIdResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFraudsterRegistrationJobsResponse
extends VoiceIdResponse
implements ToCopyableBuilder<Builder, ListFraudsterRegistrationJobsResponse> {
    private static final SdkField<List<FraudsterRegistrationJobSummary>> JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobSummaries").getter(ListFraudsterRegistrationJobsResponse.getter(ListFraudsterRegistrationJobsResponse::jobSummaries)).setter(ListFraudsterRegistrationJobsResponse.setter(Builder::jobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FraudsterRegistrationJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFraudsterRegistrationJobsResponse.getter(ListFraudsterRegistrationJobsResponse::nextToken)).setter(ListFraudsterRegistrationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("JobSummaries", JOB_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<FraudsterRegistrationJobSummary> jobSummaries;
    private final String nextToken;

    private ListFraudsterRegistrationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummaries = builder.jobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobSummaries() {
        return this.jobSummaries != null && !(this.jobSummaries instanceof SdkAutoConstructList);
    }

    public final List<FraudsterRegistrationJobSummary> jobSummaries() {
        return this.jobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobSummaries() ? this.jobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFraudsterRegistrationJobsResponse)) {
            return false;
        }
        ListFraudsterRegistrationJobsResponse other = (ListFraudsterRegistrationJobsResponse)((Object)obj);
        return this.hasJobSummaries() == other.hasJobSummaries() && Objects.equals(this.jobSummaries(), other.jobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFraudsterRegistrationJobsResponse").add("JobSummaries", this.hasJobSummaries() ? this.jobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobSummaries": {
                return Optional.ofNullable(clazz.cast(this.jobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFraudsterRegistrationJobsResponse, T> g) {
        return obj -> g.apply((ListFraudsterRegistrationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VoiceIdResponse.BuilderImpl
    implements Builder {
        private List<FraudsterRegistrationJobSummary> jobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFraudsterRegistrationJobsResponse model) {
            super(model);
            this.jobSummaries(model.jobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<FraudsterRegistrationJobSummary.Builder> getJobSummaries() {
            List<FraudsterRegistrationJobSummary.Builder> result = FraudsterRegistrationJobSummariesCopier.copyToBuilder(this.jobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobSummaries(Collection<FraudsterRegistrationJobSummary.BuilderImpl> jobSummaries) {
            this.jobSummaries = FraudsterRegistrationJobSummariesCopier.copyFromBuilder(jobSummaries);
        }

        @Override
        public final Builder jobSummaries(Collection<FraudsterRegistrationJobSummary> jobSummaries) {
            this.jobSummaries = FraudsterRegistrationJobSummariesCopier.copy(jobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(FraudsterRegistrationJobSummary ... jobSummaries) {
            this.jobSummaries(Arrays.asList(jobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(Consumer<FraudsterRegistrationJobSummary.Builder> ... jobSummaries) {
            this.jobSummaries(Stream.of(jobSummaries).map(c -> (FraudsterRegistrationJobSummary)((FraudsterRegistrationJobSummary.Builder)FraudsterRegistrationJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFraudsterRegistrationJobsResponse build() {
            return new ListFraudsterRegistrationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VoiceIdResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFraudsterRegistrationJobsResponse> {
        public Builder jobSummaries(Collection<FraudsterRegistrationJobSummary> var1);

        public Builder jobSummaries(FraudsterRegistrationJobSummary ... var1);

        public Builder jobSummaries(Consumer<FraudsterRegistrationJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

