/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.voiceid.model.FraudsterSummariesCopier;
import software.amazon.awssdk.services.voiceid.model.FraudsterSummary;
import software.amazon.awssdk.services.voiceid.model.VoiceIdResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFraudstersResponse
extends VoiceIdResponse
implements ToCopyableBuilder<Builder, ListFraudstersResponse> {
    private static final SdkField<List<FraudsterSummary>> FRAUDSTER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FraudsterSummaries").getter(ListFraudstersResponse.getter(ListFraudstersResponse::fraudsterSummaries)).setter(ListFraudstersResponse.setter(Builder::fraudsterSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FraudsterSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FraudsterSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFraudstersResponse.getter(ListFraudstersResponse::nextToken)).setter(ListFraudstersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAUDSTER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<FraudsterSummary> fraudsterSummaries;
    private final String nextToken;

    private ListFraudstersResponse(BuilderImpl builder) {
        super(builder);
        this.fraudsterSummaries = builder.fraudsterSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFraudsterSummaries() {
        return this.fraudsterSummaries != null && !(this.fraudsterSummaries instanceof SdkAutoConstructList);
    }

    public final List<FraudsterSummary> fraudsterSummaries() {
        return this.fraudsterSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFraudsterSummaries() ? this.fraudsterSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFraudstersResponse)) {
            return false;
        }
        ListFraudstersResponse other = (ListFraudstersResponse)((Object)obj);
        return this.hasFraudsterSummaries() == other.hasFraudsterSummaries() && Objects.equals(this.fraudsterSummaries(), other.fraudsterSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFraudstersResponse").add("FraudsterSummaries", this.hasFraudsterSummaries() ? this.fraudsterSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FraudsterSummaries": {
                return Optional.ofNullable(clazz.cast(this.fraudsterSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFraudstersResponse, T> g) {
        return obj -> g.apply((ListFraudstersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VoiceIdResponse.BuilderImpl
    implements Builder {
        private List<FraudsterSummary> fraudsterSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFraudstersResponse model) {
            super(model);
            this.fraudsterSummaries(model.fraudsterSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<FraudsterSummary.Builder> getFraudsterSummaries() {
            List<FraudsterSummary.Builder> result = FraudsterSummariesCopier.copyToBuilder(this.fraudsterSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFraudsterSummaries(Collection<FraudsterSummary.BuilderImpl> fraudsterSummaries) {
            this.fraudsterSummaries = FraudsterSummariesCopier.copyFromBuilder(fraudsterSummaries);
        }

        @Override
        public final Builder fraudsterSummaries(Collection<FraudsterSummary> fraudsterSummaries) {
            this.fraudsterSummaries = FraudsterSummariesCopier.copy(fraudsterSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fraudsterSummaries(FraudsterSummary ... fraudsterSummaries) {
            this.fraudsterSummaries(Arrays.asList(fraudsterSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fraudsterSummaries(Consumer<FraudsterSummary.Builder> ... fraudsterSummaries) {
            this.fraudsterSummaries(Stream.of(fraudsterSummaries).map(c -> (FraudsterSummary)((FraudsterSummary.Builder)FraudsterSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFraudstersResponse build() {
            return new ListFraudstersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends VoiceIdResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFraudstersResponse> {
        public Builder fraudsterSummaries(Collection<FraudsterSummary> var1);

        public Builder fraudsterSummaries(FraudsterSummary ... var1);

        public Builder fraudsterSummaries(Consumer<FraudsterSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

