/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FraudDetectionReason {
    KNOWN_FRAUDSTER("KNOWN_FRAUDSTER"),
    VOICE_SPOOFING("VOICE_SPOOFING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FraudDetectionReason> VALUE_MAP;
    private final String value;

    private FraudDetectionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FraudDetectionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FraudDetectionReason> knownValues() {
        EnumSet<FraudDetectionReason> knownValues = EnumSet.allOf(FraudDetectionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FraudDetectionReason.class, FraudDetectionReason::toString);
    }
}

