/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a filter to refine policies returned in a query.
 * </p>
 * <p>
 * This data type is used as a response parameter for the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html">ListPolicies</a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyFilter implements SdkPojo, Serializable, ToCopyableBuilder<PolicyFilter.Builder, PolicyFilter> {
    private static final SdkField<EntityReference> PRINCIPAL_FIELD = SdkField.<EntityReference> builder(MarshallingType.SDK_POJO)
            .memberName("principal").getter(getter(PolicyFilter::principal)).setter(setter(Builder::principal))
            .constructor(EntityReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<EntityReference> RESOURCE_FIELD = SdkField.<EntityReference> builder(MarshallingType.SDK_POJO)
            .memberName("resource").getter(getter(PolicyFilter::resource)).setter(setter(Builder::resource))
            .constructor(EntityReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyType").getter(getter(PolicyFilter::policyTypeAsString)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()).build();

    private static final SdkField<String> POLICY_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyTemplateId").getter(getter(PolicyFilter::policyTemplateId))
            .setter(setter(Builder::policyTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyTemplateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD,
            RESOURCE_FIELD, POLICY_TYPE_FIELD, POLICY_TEMPLATE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EntityReference principal;

    private final EntityReference resource;

    private final String policyType;

    private final String policyTemplateId;

    private PolicyFilter(BuilderImpl builder) {
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.policyType = builder.policyType;
        this.policyTemplateId = builder.policyTemplateId;
    }

    /**
     * <p>
     * Filters the output to only policies that reference the specified principal.
     * </p>
     * 
     * @return Filters the output to only policies that reference the specified principal.
     */
    public final EntityReference principal() {
        return principal;
    }

    /**
     * <p>
     * Filters the output to only policies that reference the specified resource.
     * </p>
     * 
     * @return Filters the output to only policies that reference the specified resource.
     */
    public final EntityReference resource() {
        return resource;
    }

    /**
     * <p>
     * Filters the output to only policies of the specified type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return Filters the output to only policies of the specified type.
     * @see PolicyType
     */
    public final PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * Filters the output to only policies of the specified type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return Filters the output to only policies of the specified type.
     * @see PolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * Filters the output to only template-linked policies that were instantiated from the specified policy template.
     * </p>
     * 
     * @return Filters the output to only template-linked policies that were instantiated from the specified policy
     *         template.
     */
    public final String policyTemplateId() {
        return policyTemplateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyTemplateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyFilter)) {
            return false;
        }
        PolicyFilter other = (PolicyFilter) obj;
        return Objects.equals(principal(), other.principal()) && Objects.equals(resource(), other.resource())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(policyTemplateId(), other.policyTemplateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyFilter").add("Principal", principal()).add("Resource", resource())
                .add("PolicyType", policyTypeAsString()).add("PolicyTemplateId", policyTemplateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "policyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "policyTemplateId":
            return Optional.ofNullable(clazz.cast(policyTemplateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("principal", PRINCIPAL_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        map.put("policyTemplateId", POLICY_TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyFilter, T> g) {
        return obj -> g.apply((PolicyFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyFilter> {
        /**
         * <p>
         * Filters the output to only policies that reference the specified principal.
         * </p>
         * 
         * @param principal
         *        Filters the output to only policies that reference the specified principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(EntityReference principal);

        /**
         * <p>
         * Filters the output to only policies that reference the specified principal.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityReference.Builder} avoiding the
         * need to create one manually via {@link EntityReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityReference.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(EntityReference)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link EntityReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(EntityReference)
         */
        default Builder principal(Consumer<EntityReference.Builder> principal) {
            return principal(EntityReference.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * Filters the output to only policies that reference the specified resource.
         * </p>
         * 
         * @param resource
         *        Filters the output to only policies that reference the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(EntityReference resource);

        /**
         * <p>
         * Filters the output to only policies that reference the specified resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityReference.Builder} avoiding the
         * need to create one manually via {@link EntityReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityReference.Builder#build()} is called immediately and its
         * result is passed to {@link #resource(EntityReference)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link EntityReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(EntityReference)
         */
        default Builder resource(Consumer<EntityReference.Builder> resource) {
            return resource(EntityReference.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * Filters the output to only policies of the specified type.
         * </p>
         * 
         * @param policyType
         *        Filters the output to only policies of the specified type.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * Filters the output to only policies of the specified type.
         * </p>
         * 
         * @param policyType
         *        Filters the output to only policies of the specified type.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * <p>
         * Filters the output to only template-linked policies that were instantiated from the specified policy
         * template.
         * </p>
         * 
         * @param policyTemplateId
         *        Filters the output to only template-linked policies that were instantiated from the specified policy
         *        template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTemplateId(String policyTemplateId);
    }

    static final class BuilderImpl implements Builder {
        private EntityReference principal;

        private EntityReference resource;

        private String policyType;

        private String policyTemplateId;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyFilter model) {
            principal(model.principal);
            resource(model.resource);
            policyType(model.policyType);
            policyTemplateId(model.policyTemplateId);
        }

        public final EntityReference.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(EntityReference.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(EntityReference principal) {
            this.principal = principal;
            return this;
        }

        public final EntityReference.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(EntityReference.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(EntityReference resource) {
            this.resource = resource;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getPolicyTemplateId() {
            return policyTemplateId;
        }

        public final void setPolicyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
        }

        @Override
        public final Builder policyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
            return this;
        }

        @Override
        public PolicyFilter build() {
            return new PolicyFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
