/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IsAuthorizedWithTokenRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<IsAuthorizedWithTokenRequest.Builder, IsAuthorizedWithTokenRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(IsAuthorizedWithTokenRequest::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<String> IDENTITY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityToken").getter(getter(IsAuthorizedWithTokenRequest::identityToken))
            .setter(setter(Builder::identityToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityToken").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(IsAuthorizedWithTokenRequest::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<ActionIdentifier> ACTION_FIELD = SdkField.<ActionIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(IsAuthorizedWithTokenRequest::action)).setter(setter(Builder::action))
            .constructor(ActionIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<EntityIdentifier> RESOURCE_FIELD = SdkField
            .<EntityIdentifier> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(IsAuthorizedWithTokenRequest::resource)).setter(setter(Builder::resource))
            .constructor(EntityIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<ContextDefinition> CONTEXT_FIELD = SdkField
            .<ContextDefinition> builder(MarshallingType.SDK_POJO).memberName("context")
            .getter(getter(IsAuthorizedWithTokenRequest::context)).setter(setter(Builder::context))
            .constructor(ContextDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final SdkField<EntitiesDefinition> ENTITIES_FIELD = SdkField
            .<EntitiesDefinition> builder(MarshallingType.SDK_POJO).memberName("entities")
            .getter(getter(IsAuthorizedWithTokenRequest::entities)).setter(setter(Builder::entities))
            .constructor(EntitiesDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            IDENTITY_TOKEN_FIELD, ACCESS_TOKEN_FIELD, ACTION_FIELD, RESOURCE_FIELD, CONTEXT_FIELD, ENTITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyStoreId;

    private final String identityToken;

    private final String accessToken;

    private final ActionIdentifier action;

    private final EntityIdentifier resource;

    private final ContextDefinition context;

    private final EntitiesDefinition entities;

    private IsAuthorizedWithTokenRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.identityToken = builder.identityToken;
        this.accessToken = builder.accessToken;
        this.action = builder.action;
        this.resource = builder.resource;
        this.context = builder.context;
        this.entities = builder.entities;
    }

    /**
     * <p>
     * Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization
     * decision for the input.
     * </p>
     * 
     * @return Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization
     *         decision for the input.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * Specifies an identity token for the principal to be authorized. This token is provided to you by the identity
     * provider (IdP) associated with the specified identity source. You must specify either an <code>accessToken</code>
     * , an <code>identityToken</code>, or both.
     * </p>
     * <p>
     * Must be an ID token. Verified Permissions returns an error if the <code>token_use</code> claim in the submitted
     * token isn't <code>id</code>.
     * </p>
     * 
     * @return Specifies an identity token for the principal to be authorized. This token is provided to you by the
     *         identity provider (IdP) associated with the specified identity source. You must specify either an
     *         <code>accessToken</code>, an <code>identityToken</code>, or both.</p>
     *         <p>
     *         Must be an ID token. Verified Permissions returns an error if the <code>token_use</code> claim in the
     *         submitted token isn't <code>id</code>.
     */
    public final String identityToken() {
        return identityToken;
    }

    /**
     * <p>
     * Specifies an access token for the principal to be authorized. This token is provided to you by the identity
     * provider (IdP) associated with the specified identity source. You must specify either an <code>accessToken</code>
     * , an <code>identityToken</code>, or both.
     * </p>
     * <p>
     * Must be an access token. Verified Permissions returns an error if the <code>token_use</code> claim in the
     * submitted token isn't <code>access</code>.
     * </p>
     * 
     * @return Specifies an access token for the principal to be authorized. This token is provided to you by the
     *         identity provider (IdP) associated with the specified identity source. You must specify either an
     *         <code>accessToken</code>, an <code>identityToken</code>, or both.</p>
     *         <p>
     *         Must be an access token. Verified Permissions returns an error if the <code>token_use</code> claim in the
     *         submitted token isn't <code>access</code>.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * Specifies the requested action to be authorized. Is the specified principal authorized to perform this action on
     * the specified resource.
     * </p>
     * 
     * @return Specifies the requested action to be authorized. Is the specified principal authorized to perform this
     *         action on the specified resource.
     */
    public final ActionIdentifier action() {
        return action;
    }

    /**
     * <p>
     * Specifies the resource for which the authorization decision is made. For example, is the principal allowed to
     * perform the action on the resource?
     * </p>
     * 
     * @return Specifies the resource for which the authorization decision is made. For example, is the principal
     *         allowed to perform the action on the resource?
     */
    public final EntityIdentifier resource() {
        return resource;
    }

    /**
     * <p>
     * Specifies additional context that can be used to make more granular authorization decisions.
     * </p>
     * 
     * @return Specifies additional context that can be used to make more granular authorization decisions.
     */
    public final ContextDefinition context() {
        return context;
    }

    /**
     * <p>
     * (Optional) Specifies the list of resources and their associated attributes that Verified Permissions can examine
     * when evaluating the policies. These additional entities and their attributes can be referenced and checked by
     * conditional elements in the policies in the specified policy store.
     * </p>
     * <important>
     * <p>
     * You can't include principals in this parameter, only resource and action entities. This parameter can't include
     * any entities of a type that matches the user or group entity types that you defined in your identity source.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>IsAuthorizedWithToken</code> operation takes principal attributes from <b> <i>only</i> </b> the
     * <code>identityToken</code> or <code>accessToken</code> passed to the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * For action entities, you can include only their <code>Identifier</code> and <code>EntityType</code>.
     * </p>
     * </li>
     * </ul>
     * </important>
     * 
     * @return (Optional) Specifies the list of resources and their associated attributes that Verified Permissions can
     *         examine when evaluating the policies. These additional entities and their attributes can be referenced
     *         and checked by conditional elements in the policies in the specified policy store.</p> <important>
     *         <p>
     *         You can't include principals in this parameter, only resource and action entities. This parameter can't
     *         include any entities of a type that matches the user or group entity types that you defined in your
     *         identity source.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>IsAuthorizedWithToken</code> operation takes principal attributes from <b> <i>only</i> </b> the
     *         <code>identityToken</code> or <code>accessToken</code> passed to the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For action entities, you can include only their <code>Identifier</code> and <code>EntityType</code>.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final EntitiesDefinition entities() {
        return entities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(identityToken());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(entities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsAuthorizedWithTokenRequest)) {
            return false;
        }
        IsAuthorizedWithTokenRequest other = (IsAuthorizedWithTokenRequest) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId()) && Objects.equals(identityToken(), other.identityToken())
                && Objects.equals(accessToken(), other.accessToken()) && Objects.equals(action(), other.action())
                && Objects.equals(resource(), other.resource()) && Objects.equals(context(), other.context())
                && Objects.equals(entities(), other.entities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IsAuthorizedWithTokenRequest").add("PolicyStoreId", policyStoreId())
                .add("IdentityToken", identityToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***").add("Action", action())
                .add("Resource", resource()).add("Context", context()).add("Entities", entities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "identityToken":
            return Optional.ofNullable(clazz.cast(identityToken()));
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        case "entities":
            return Optional.ofNullable(clazz.cast(entities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("identityToken", IDENTITY_TOKEN_FIELD);
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("entities", ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IsAuthorizedWithTokenRequest, T> g) {
        return obj -> g.apply((IsAuthorizedWithTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, IsAuthorizedWithTokenRequest> {
        /**
         * <p>
         * Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization
         * decision for the input.
         * </p>
         * 
         * @param policyStoreId
         *        Specifies the ID of the policy store. Policies in this policy store will be used to make an
         *        authorization decision for the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * Specifies an identity token for the principal to be authorized. This token is provided to you by the identity
         * provider (IdP) associated with the specified identity source. You must specify either an
         * <code>accessToken</code>, an <code>identityToken</code>, or both.
         * </p>
         * <p>
         * Must be an ID token. Verified Permissions returns an error if the <code>token_use</code> claim in the
         * submitted token isn't <code>id</code>.
         * </p>
         * 
         * @param identityToken
         *        Specifies an identity token for the principal to be authorized. This token is provided to you by the
         *        identity provider (IdP) associated with the specified identity source. You must specify either an
         *        <code>accessToken</code>, an <code>identityToken</code>, or both.</p>
         *        <p>
         *        Must be an ID token. Verified Permissions returns an error if the <code>token_use</code> claim in the
         *        submitted token isn't <code>id</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityToken(String identityToken);

        /**
         * <p>
         * Specifies an access token for the principal to be authorized. This token is provided to you by the identity
         * provider (IdP) associated with the specified identity source. You must specify either an
         * <code>accessToken</code>, an <code>identityToken</code>, or both.
         * </p>
         * <p>
         * Must be an access token. Verified Permissions returns an error if the <code>token_use</code> claim in the
         * submitted token isn't <code>access</code>.
         * </p>
         * 
         * @param accessToken
         *        Specifies an access token for the principal to be authorized. This token is provided to you by the
         *        identity provider (IdP) associated with the specified identity source. You must specify either an
         *        <code>accessToken</code>, an <code>identityToken</code>, or both.</p>
         *        <p>
         *        Must be an access token. Verified Permissions returns an error if the <code>token_use</code> claim in
         *        the submitted token isn't <code>access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * Specifies the requested action to be authorized. Is the specified principal authorized to perform this action
         * on the specified resource.
         * </p>
         * 
         * @param action
         *        Specifies the requested action to be authorized. Is the specified principal authorized to perform this
         *        action on the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(ActionIdentifier action);

        /**
         * <p>
         * Specifies the requested action to be authorized. Is the specified principal authorized to perform this action
         * on the specified resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionIdentifier.Builder} avoiding the
         * need to create one manually via {@link ActionIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #action(ActionIdentifier)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link ActionIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(ActionIdentifier)
         */
        default Builder action(Consumer<ActionIdentifier.Builder> action) {
            return action(ActionIdentifier.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * Specifies the resource for which the authorization decision is made. For example, is the principal allowed to
         * perform the action on the resource?
         * </p>
         * 
         * @param resource
         *        Specifies the resource for which the authorization decision is made. For example, is the principal
         *        allowed to perform the action on the resource?
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(EntityIdentifier resource);

        /**
         * <p>
         * Specifies the resource for which the authorization decision is made. For example, is the principal allowed to
         * perform the action on the resource?
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityIdentifier.Builder} avoiding the
         * need to create one manually via {@link EntityIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #resource(EntityIdentifier)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link EntityIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(EntityIdentifier)
         */
        default Builder resource(Consumer<EntityIdentifier.Builder> resource) {
            return resource(EntityIdentifier.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * Specifies additional context that can be used to make more granular authorization decisions.
         * </p>
         * 
         * @param context
         *        Specifies additional context that can be used to make more granular authorization decisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(ContextDefinition context);

        /**
         * <p>
         * Specifies additional context that can be used to make more granular authorization decisions.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextDefinition.Builder} avoiding the
         * need to create one manually via {@link ContextDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #context(ContextDefinition)}.
         * 
         * @param context
         *        a consumer that will call methods on {@link ContextDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #context(ContextDefinition)
         */
        default Builder context(Consumer<ContextDefinition.Builder> context) {
            return context(ContextDefinition.builder().applyMutation(context).build());
        }

        /**
         * <p>
         * (Optional) Specifies the list of resources and their associated attributes that Verified Permissions can
         * examine when evaluating the policies. These additional entities and their attributes can be referenced and
         * checked by conditional elements in the policies in the specified policy store.
         * </p>
         * <important>
         * <p>
         * You can't include principals in this parameter, only resource and action entities. This parameter can't
         * include any entities of a type that matches the user or group entity types that you defined in your identity
         * source.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>IsAuthorizedWithToken</code> operation takes principal attributes from <b> <i>only</i> </b> the
         * <code>identityToken</code> or <code>accessToken</code> passed to the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * For action entities, you can include only their <code>Identifier</code> and <code>EntityType</code>.
         * </p>
         * </li>
         * </ul>
         * </important>
         * 
         * @param entities
         *        (Optional) Specifies the list of resources and their associated attributes that Verified Permissions
         *        can examine when evaluating the policies. These additional entities and their attributes can be
         *        referenced and checked by conditional elements in the policies in the specified policy store.</p>
         *        <important>
         *        <p>
         *        You can't include principals in this parameter, only resource and action entities. This parameter
         *        can't include any entities of a type that matches the user or group entity types that you defined in
         *        your identity source.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>IsAuthorizedWithToken</code> operation takes principal attributes from <b> <i>only</i> </b>
         *        the <code>identityToken</code> or <code>accessToken</code> passed to the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For action entities, you can include only their <code>Identifier</code> and <code>EntityType</code>.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(EntitiesDefinition entities);

        /**
         * <p>
         * (Optional) Specifies the list of resources and their associated attributes that Verified Permissions can
         * examine when evaluating the policies. These additional entities and their attributes can be referenced and
         * checked by conditional elements in the policies in the specified policy store.
         * </p>
         * <important>
         * <p>
         * You can't include principals in this parameter, only resource and action entities. This parameter can't
         * include any entities of a type that matches the user or group entity types that you defined in your identity
         * source.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>IsAuthorizedWithToken</code> operation takes principal attributes from <b> <i>only</i> </b> the
         * <code>identityToken</code> or <code>accessToken</code> passed to the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * For action entities, you can include only their <code>Identifier</code> and <code>EntityType</code>.
         * </p>
         * </li>
         * </ul>
         * </important> This is a convenience method that creates an instance of the {@link EntitiesDefinition.Builder}
         * avoiding the need to create one manually via {@link EntitiesDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntitiesDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #entities(EntitiesDefinition)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link EntitiesDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(EntitiesDefinition)
         */
        default Builder entities(Consumer<EntitiesDefinition.Builder> entities) {
            return entities(EntitiesDefinition.builder().applyMutation(entities).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String policyStoreId;

        private String identityToken;

        private String accessToken;

        private ActionIdentifier action;

        private EntityIdentifier resource;

        private ContextDefinition context;

        private EntitiesDefinition entities;

        private BuilderImpl() {
        }

        private BuilderImpl(IsAuthorizedWithTokenRequest model) {
            super(model);
            policyStoreId(model.policyStoreId);
            identityToken(model.identityToken);
            accessToken(model.accessToken);
            action(model.action);
            resource(model.resource);
            context(model.context);
            entities(model.entities);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getIdentityToken() {
            return identityToken;
        }

        public final void setIdentityToken(String identityToken) {
            this.identityToken = identityToken;
        }

        @Override
        public final Builder identityToken(String identityToken) {
            this.identityToken = identityToken;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final ActionIdentifier.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(ActionIdentifier.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ActionIdentifier action) {
            this.action = action;
            return this;
        }

        public final EntityIdentifier.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(EntityIdentifier.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(EntityIdentifier resource) {
            this.resource = resource;
            return this;
        }

        public final ContextDefinition.Builder getContext() {
            return context != null ? context.toBuilder() : null;
        }

        public final void setContext(ContextDefinition.BuilderImpl context) {
            this.context = context != null ? context.build() : null;
        }

        @Override
        public final Builder context(ContextDefinition context) {
            this.context = context;
            return this;
        }

        public final EntitiesDefinition.Builder getEntities() {
            return entities != null ? entities.toBuilder() : null;
        }

        public final void setEntities(EntitiesDefinition.BuilderImpl entities) {
            this.entities = entities != null ? entities.build() : null;
        }

        @Override
        public final Builder entities(EntitiesDefinition entities) {
            this.entities = entities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IsAuthorizedWithTokenRequest build() {
            return new IsAuthorizedWithTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
