/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines an identity source.
 * </p>
 * <p>
 * This data type is a response parameter to the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html"
 * >ListIdentitySources</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentitySourceItem implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentitySourceItem.Builder, IdentitySourceItem> {
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate")
            .getter(getter(IdentitySourceItem::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<IdentitySourceItemDetails> DETAILS_FIELD = SdkField
            .<IdentitySourceItemDetails> builder(MarshallingType.SDK_POJO).memberName("details")
            .getter(getter(IdentitySourceItem::details)).setter(setter(Builder::details))
            .constructor(IdentitySourceItemDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<String> IDENTITY_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identitySourceId").getter(getter(IdentitySourceItem::identitySourceId))
            .setter(setter(Builder::identitySourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identitySourceId").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate")
            .getter(getter(IdentitySourceItem::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(IdentitySourceItem::policyStoreId)).setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<String> PRINCIPAL_ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalEntityType").getter(getter(IdentitySourceItem::principalEntityType))
            .setter(setter(Builder::principalEntityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalEntityType").build())
            .build();

    private static final SdkField<ConfigurationItem> CONFIGURATION_FIELD = SdkField
            .<ConfigurationItem> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(IdentitySourceItem::configuration)).setter(setter(Builder::configuration))
            .constructor(ConfigurationItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD,
            DETAILS_FIELD, IDENTITY_SOURCE_ID_FIELD, LAST_UPDATED_DATE_FIELD, POLICY_STORE_ID_FIELD, PRINCIPAL_ENTITY_TYPE_FIELD,
            CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdDate;

    private final IdentitySourceItemDetails details;

    private final String identitySourceId;

    private final Instant lastUpdatedDate;

    private final String policyStoreId;

    private final String principalEntityType;

    private final ConfigurationItem configuration;

    private IdentitySourceItem(BuilderImpl builder) {
        this.createdDate = builder.createdDate;
        this.details = builder.details;
        this.identitySourceId = builder.identitySourceId;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.policyStoreId = builder.policyStoreId;
        this.principalEntityType = builder.principalEntityType;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The date and time the identity source was originally created.
     * </p>
     * 
     * @return The date and time the identity source was originally created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * A structure that contains the details of the associated identity provider (IdP).
     * </p>
     * 
     * @return A structure that contains the details of the associated identity provider (IdP).
     * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration
     */
    @Deprecated
    public final IdentitySourceItemDetails details() {
        return details;
    }

    /**
     * <p>
     * The unique identifier of the identity source.
     * </p>
     * 
     * @return The unique identifier of the identity source.
     */
    public final String identitySourceId() {
        return identitySourceId;
    }

    /**
     * <p>
     * The date and time the identity source was most recently updated.
     * </p>
     * 
     * @return The date and time the identity source was most recently updated.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The identifier of the policy store that contains the identity source.
     * </p>
     * 
     * @return The identifier of the policy store that contains the identity source.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * The Cedar entity type of the principals returned from the IdP associated with this identity source.
     * </p>
     * 
     * @return The Cedar entity type of the principals returned from the IdP associated with this identity source.
     */
    public final String principalEntityType() {
        return principalEntityType;
    }

    /**
     * <p>
     * Contains configuration information about an identity source.
     * </p>
     * 
     * @return Contains configuration information about an identity source.
     */
    public final ConfigurationItem configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(identitySourceId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(principalEntityType());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentitySourceItem)) {
            return false;
        }
        IdentitySourceItem other = (IdentitySourceItem) obj;
        return Objects.equals(createdDate(), other.createdDate()) && Objects.equals(details(), other.details())
                && Objects.equals(identitySourceId(), other.identitySourceId())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(policyStoreId(), other.policyStoreId())
                && Objects.equals(principalEntityType(), other.principalEntityType())
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentitySourceItem").add("CreatedDate", createdDate()).add("Details", details())
                .add("IdentitySourceId", identitySourceId()).add("LastUpdatedDate", lastUpdatedDate())
                .add("PolicyStoreId", policyStoreId())
                .add("PrincipalEntityType", principalEntityType() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "identitySourceId":
            return Optional.ofNullable(clazz.cast(identitySourceId()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "principalEntityType":
            return Optional.ofNullable(clazz.cast(principalEntityType()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("details", DETAILS_FIELD);
        map.put("identitySourceId", IDENTITY_SOURCE_ID_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("principalEntityType", PRINCIPAL_ENTITY_TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentitySourceItem, T> g) {
        return obj -> g.apply((IdentitySourceItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentitySourceItem> {
        /**
         * <p>
         * The date and time the identity source was originally created.
         * </p>
         * 
         * @param createdDate
         *        The date and time the identity source was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * A structure that contains the details of the associated identity provider (IdP).
         * </p>
         * 
         * @param details
         *        A structure that contains the details of the associated identity provider (IdP).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration
         */
        @Deprecated
        Builder details(IdentitySourceItemDetails details);

        /**
         * <p>
         * A structure that contains the details of the associated identity provider (IdP).
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentitySourceItemDetails.Builder}
         * avoiding the need to create one manually via {@link IdentitySourceItemDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentitySourceItemDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #details(IdentitySourceItemDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link IdentitySourceItemDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(IdentitySourceItemDetails)
         * @deprecated This attribute has been replaced by configuration.cognitoUserPoolConfiguration
         */
        @Deprecated
        default Builder details(Consumer<IdentitySourceItemDetails.Builder> details) {
            return details(IdentitySourceItemDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The unique identifier of the identity source.
         * </p>
         * 
         * @param identitySourceId
         *        The unique identifier of the identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySourceId(String identitySourceId);

        /**
         * <p>
         * The date and time the identity source was most recently updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date and time the identity source was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The identifier of the policy store that contains the identity source.
         * </p>
         * 
         * @param policyStoreId
         *        The identifier of the policy store that contains the identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * The Cedar entity type of the principals returned from the IdP associated with this identity source.
         * </p>
         * 
         * @param principalEntityType
         *        The Cedar entity type of the principals returned from the IdP associated with this identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalEntityType(String principalEntityType);

        /**
         * <p>
         * Contains configuration information about an identity source.
         * </p>
         * 
         * @param configuration
         *        Contains configuration information about an identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ConfigurationItem configuration);

        /**
         * <p>
         * Contains configuration information about an identity source.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationItem.Builder} avoiding the
         * need to create one manually via {@link ConfigurationItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationItem.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(ConfigurationItem)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ConfigurationItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ConfigurationItem)
         */
        default Builder configuration(Consumer<ConfigurationItem.Builder> configuration) {
            return configuration(ConfigurationItem.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant createdDate;

        private IdentitySourceItemDetails details;

        private String identitySourceId;

        private Instant lastUpdatedDate;

        private String policyStoreId;

        private String principalEntityType;

        private ConfigurationItem configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentitySourceItem model) {
            createdDate(model.createdDate);
            details(model.details);
            identitySourceId(model.identitySourceId);
            lastUpdatedDate(model.lastUpdatedDate);
            policyStoreId(model.policyStoreId);
            principalEntityType(model.principalEntityType);
            configuration(model.configuration);
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Deprecated
        public final IdentitySourceItemDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        @Deprecated
        public final void setDetails(IdentitySourceItemDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        @Deprecated
        public final Builder details(IdentitySourceItemDetails details) {
            this.details = details;
            return this;
        }

        public final String getIdentitySourceId() {
            return identitySourceId;
        }

        public final void setIdentitySourceId(String identitySourceId) {
            this.identitySourceId = identitySourceId;
        }

        @Override
        public final Builder identitySourceId(String identitySourceId) {
            this.identitySourceId = identitySourceId;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPrincipalEntityType() {
            return principalEntityType;
        }

        public final void setPrincipalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
        }

        @Override
        public final Builder principalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
            return this;
        }

        public final ConfigurationItem.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ConfigurationItem.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ConfigurationItem configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public IdentitySourceItem build() {
            return new IdentitySourceItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
