/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIdentitySourceRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<CreateIdentitySourceRequest.Builder, CreateIdentitySourceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateIdentitySourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(CreateIdentitySourceRequest::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<Configuration> CONFIGURATION_FIELD = SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
            .memberName("configuration").getter(getter(CreateIdentitySourceRequest::configuration))
            .setter(setter(Builder::configuration)).constructor(Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> PRINCIPAL_ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalEntityType").getter(getter(CreateIdentitySourceRequest::principalEntityType))
            .setter(setter(Builder::principalEntityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalEntityType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            POLICY_STORE_ID_FIELD, CONFIGURATION_FIELD, PRINCIPAL_ENTITY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String policyStoreId;

    private final Configuration configuration;

    private final String principalEntityType;

    private CreateIdentitySourceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.policyStoreId = builder.policyStoreId;
        this.configuration = builder.configuration;
        this.principalEntityType = builder.principalEntityType;
    }

    /**
     * <p>
     * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you
     * safely retry the request without accidentally performing the same operation a second time. Passing the same value
     * to a later call to an operation requires that you also pass the same value for all other parameters. We recommend
     * that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
     * </p>
     * <p>
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     * </p>
     * <p>
     * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails
     * with an <code>ConflictException</code> error.
     * </p>
     * <p>
     * Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the next request
     * with the same parameters performs the operation again regardless of the value of <code>ClientToken</code>.
     * </p>
     * 
     * @return Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This
     *         lets you safely retry the request without accidentally performing the same operation a second time.
     *         Passing the same value to a later call to an operation requires that you also pass the same value for all
     *         other parameters. We recommend that you use a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
     *         <p>
     *         If you don't provide this value, then Amazon Web Services generates a random one for you.
     *         </p>
     *         <p>
     *         If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
     *         retry fails with an <code>ConflictException</code> error.
     *         </p>
     *         <p>
     *         Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the next
     *         request with the same parameters performs the operation again regardless of the value of
     *         <code>ClientToken</code>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the ID of the policy store in which you want to store this identity source. Only policies and requests
     * made using this policy store can reference identities from the identity provider configured in the new identity
     * source.
     * </p>
     * 
     * @return Specifies the ID of the policy store in which you want to store this identity source. Only policies and
     *         requests made using this policy store can reference identities from the identity provider configured in
     *         the new identity source.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * Specifies the details required to communicate with the identity provider (IdP) associated with this identity
     * source.
     * </p>
     * 
     * @return Specifies the details required to communicate with the identity provider (IdP) associated with this
     *         identity source.
     */
    public final Configuration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Specifies the namespace and data type of the principals generated for identities authenticated by the new
     * identity source.
     * </p>
     * 
     * @return Specifies the namespace and data type of the principals generated for identities authenticated by the new
     *         identity source.
     */
    public final String principalEntityType() {
        return principalEntityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(principalEntityType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentitySourceRequest)) {
            return false;
        }
        CreateIdentitySourceRequest other = (CreateIdentitySourceRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(policyStoreId(), other.policyStoreId())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(principalEntityType(), other.principalEntityType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIdentitySourceRequest").add("ClientToken", clientToken())
                .add("PolicyStoreId", policyStoreId()).add("Configuration", configuration())
                .add("PrincipalEntityType", principalEntityType() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "principalEntityType":
            return Optional.ofNullable(clazz.cast(principalEntityType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("principalEntityType", PRINCIPAL_ENTITY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIdentitySourceRequest, T> g) {
        return obj -> g.apply((CreateIdentitySourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIdentitySourceRequest> {
        /**
         * <p>
         * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets
         * you safely retry the request without accidentally performing the same operation a second time. Passing the
         * same value to a later call to an operation requires that you also pass the same value for all other
         * parameters. We recommend that you use a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
         * </p>
         * <p>
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         * </p>
         * <p>
         * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry
         * fails with an <code>ConflictException</code> error.
         * </p>
         * <p>
         * Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the next
         * request with the same parameters performs the operation again regardless of the value of
         * <code>ClientToken</code>.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This
         *        lets you safely retry the request without accidentally performing the same operation a second time.
         *        Passing the same value to a later call to an operation requires that you also pass the same value for
         *        all other parameters. We recommend that you use a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
         *        <p>
         *        If you don't provide this value, then Amazon Web Services generates a random one for you.
         *        </p>
         *        <p>
         *        If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
         *        retry fails with an <code>ConflictException</code> error.
         *        </p>
         *        <p>
         *        Verified Permissions recognizes a <code>ClientToken</code> for eight hours. After eight hours, the
         *        next request with the same parameters performs the operation again regardless of the value of
         *        <code>ClientToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the ID of the policy store in which you want to store this identity source. Only policies and
         * requests made using this policy store can reference identities from the identity provider configured in the
         * new identity source.
         * </p>
         * 
         * @param policyStoreId
         *        Specifies the ID of the policy store in which you want to store this identity source. Only policies
         *        and requests made using this policy store can reference identities from the identity provider
         *        configured in the new identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * Specifies the details required to communicate with the identity provider (IdP) associated with this identity
         * source.
         * </p>
         * 
         * @param configuration
         *        Specifies the details required to communicate with the identity provider (IdP) associated with this
         *        identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Configuration configuration);

        /**
         * <p>
         * Specifies the details required to communicate with the identity provider (IdP) associated with this identity
         * source.
         * </p>
         * This is a convenience method that creates an instance of the {@link Configuration.Builder} avoiding the need
         * to create one manually via {@link Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(Configuration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(Configuration)
         */
        default Builder configuration(Consumer<Configuration.Builder> configuration) {
            return configuration(Configuration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Specifies the namespace and data type of the principals generated for identities authenticated by the new
         * identity source.
         * </p>
         * 
         * @param principalEntityType
         *        Specifies the namespace and data type of the principals generated for identities authenticated by the
         *        new identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalEntityType(String principalEntityType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String policyStoreId;

        private Configuration configuration;

        private String principalEntityType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdentitySourceRequest model) {
            super(model);
            clientToken(model.clientToken);
            policyStoreId(model.policyStoreId);
            configuration(model.configuration);
            principalEntityType(model.principalEntityType);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final Configuration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(Configuration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getPrincipalEntityType() {
            return principalEntityType;
        }

        public final void setPrincipalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
        }

        @Override
        public final Builder principalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIdentitySourceRequest build() {
            return new CreateIdentitySourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
