/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchIsAuthorizedResponse extends VerifiedPermissionsResponse implements
        ToCopyableBuilder<BatchIsAuthorizedResponse.Builder, BatchIsAuthorizedResponse> {
    private static final SdkField<List<BatchIsAuthorizedOutputItem>> RESULTS_FIELD = SdkField
            .<List<BatchIsAuthorizedOutputItem>> builder(MarshallingType.LIST)
            .memberName("results")
            .getter(getter(BatchIsAuthorizedResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchIsAuthorizedOutputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchIsAuthorizedOutputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchIsAuthorizedOutputItem> results;

    private BatchIsAuthorizedResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A series of <code>Allow</code> or <code>Deny</code> decisions for each request, and the policies that produced
     * them. These results are returned in the order they were requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return A series of <code>Allow</code> or <code>Deny</code> decisions for each request, and the policies that
     *         produced them. These results are returned in the order they were requested.
     */
    public final List<BatchIsAuthorizedOutputItem> results() {
        return results;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchIsAuthorizedResponse)) {
            return false;
        }
        BatchIsAuthorizedResponse other = (BatchIsAuthorizedResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchIsAuthorizedResponse").add("Results", hasResults() ? results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "results":
            return Optional.ofNullable(clazz.cast(results()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("results", RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchIsAuthorizedResponse, T> g) {
        return obj -> g.apply((BatchIsAuthorizedResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VerifiedPermissionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchIsAuthorizedResponse> {
        /**
         * <p>
         * A series of <code>Allow</code> or <code>Deny</code> decisions for each request, and the policies that
         * produced them. These results are returned in the order they were requested.
         * </p>
         * 
         * @param results
         *        A series of <code>Allow</code> or <code>Deny</code> decisions for each request, and the policies that
         *        produced them. These results are returned in the order they were requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<BatchIsAuthorizedOutputItem> results);

        /**
         * <p>
         * A series of <code>Allow</code> or <code>Deny</code> decisions for each request, and the policies that
         * produced them. These results are returned in the order they were requested.
         * </p>
         * 
         * @param results
         *        A series of <code>Allow</code> or <code>Deny</code> decisions for each request, and the policies that
         *        produced them. These results are returned in the order they were requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(BatchIsAuthorizedOutputItem... results);

        /**
         * <p>
         * A series of <code>Allow</code> or <code>Deny</code> decisions for each request, and the policies that
         * produced them. These results are returned in the order they were requested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedOutputItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedOutputItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedOutputItem.Builder#build()}
         * is called immediately and its result is passed to {@link #results(List<BatchIsAuthorizedOutputItem>)}.
         * 
         * @param results
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedOutputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(java.util.Collection<BatchIsAuthorizedOutputItem>)
         */
        Builder results(Consumer<BatchIsAuthorizedOutputItem.Builder>... results);
    }

    static final class BuilderImpl extends VerifiedPermissionsResponse.BuilderImpl implements Builder {
        private List<BatchIsAuthorizedOutputItem> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchIsAuthorizedResponse model) {
            super(model);
            results(model.results);
        }

        public final List<BatchIsAuthorizedOutputItem.Builder> getResults() {
            List<BatchIsAuthorizedOutputItem.Builder> result = BatchIsAuthorizedOutputListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<BatchIsAuthorizedOutputItem.BuilderImpl> results) {
            this.results = BatchIsAuthorizedOutputListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<BatchIsAuthorizedOutputItem> results) {
            this.results = BatchIsAuthorizedOutputListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(BatchIsAuthorizedOutputItem... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<BatchIsAuthorizedOutputItem.Builder>... results) {
            results(Stream.of(results).map(c -> BatchIsAuthorizedOutputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchIsAuthorizedResponse build() {
            return new BatchIsAuthorizedResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
