/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.DeletionProtection;
import software.amazon.awssdk.services.verifiedpermissions.model.ValidationSettings;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePolicyStoreRequest
extends VerifiedPermissionsRequest
implements ToCopyableBuilder<Builder, CreatePolicyStoreRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreatePolicyStoreRequest.getter(CreatePolicyStoreRequest::clientToken)).setter(CreatePolicyStoreRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ValidationSettings> VALIDATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validationSettings").getter(CreatePolicyStoreRequest.getter(CreatePolicyStoreRequest::validationSettings)).setter(CreatePolicyStoreRequest.setter(Builder::validationSettings)).constructor(ValidationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationSettings").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreatePolicyStoreRequest.getter(CreatePolicyStoreRequest::description)).setter(CreatePolicyStoreRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deletionProtection").getter(CreatePolicyStoreRequest.getter(CreatePolicyStoreRequest::deletionProtectionAsString)).setter(CreatePolicyStoreRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, VALIDATION_SETTINGS_FIELD, DESCRIPTION_FIELD, DELETION_PROTECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePolicyStoreRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final ValidationSettings validationSettings;
    private final String description;
    private final String deletionProtection;

    private CreatePolicyStoreRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.validationSettings = builder.validationSettings;
        this.description = builder.description;
        this.deletionProtection = builder.deletionProtection;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ValidationSettings validationSettings() {
        return this.validationSettings;
    }

    public final String description() {
        return this.description;
    }

    public final DeletionProtection deletionProtection() {
        return DeletionProtection.fromValue(this.deletionProtection);
    }

    public final String deletionProtectionAsString() {
        return this.deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyStoreRequest)) {
            return false;
        }
        CreatePolicyStoreRequest other = (CreatePolicyStoreRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.validationSettings(), other.validationSettings()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deletionProtectionAsString(), other.deletionProtectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePolicyStoreRequest").add("ClientToken", (Object)this.clientToken()).add("ValidationSettings", (Object)this.validationSettings()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DeletionProtection", (Object)this.deletionProtectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "validationSettings": {
                return Optional.ofNullable(clazz.cast(this.validationSettings()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "deletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("validationSettings", VALIDATION_SETTINGS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyStoreRequest, T> g) {
        return obj -> g.apply((CreatePolicyStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private ValidationSettings validationSettings;
        private String description;
        private String deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyStoreRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.validationSettings(model.validationSettings);
            this.description(model.description);
            this.deletionProtection(model.deletionProtection);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ValidationSettings.Builder getValidationSettings() {
            return this.validationSettings != null ? this.validationSettings.toBuilder() : null;
        }

        public final void setValidationSettings(ValidationSettings.BuilderImpl validationSettings) {
            this.validationSettings = validationSettings != null ? validationSettings.build() : null;
        }

        @Override
        public final Builder validationSettings(ValidationSettings validationSettings) {
            this.validationSettings = validationSettings;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(String deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(String deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        @Override
        public final Builder deletionProtection(DeletionProtection deletionProtection) {
            this.deletionProtection(deletionProtection == null ? null : deletionProtection.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePolicyStoreRequest build() {
            return new CreatePolicyStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePolicyStoreRequest> {
        public Builder clientToken(String var1);

        public Builder validationSettings(ValidationSettings var1);

        default public Builder validationSettings(Consumer<ValidationSettings.Builder> validationSettings) {
            return this.validationSettings((ValidationSettings)((ValidationSettings.Builder)ValidationSettings.builder().applyMutation(validationSettings)).build());
        }

        public Builder description(String var1);

        public Builder deletionProtection(String var1);

        public Builder deletionProtection(DeletionProtection var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

