/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.verifiedpermissions.model.EntityItem;
import software.amazon.awssdk.services.verifiedpermissions.model.EntityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntitiesDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntitiesDefinition> {
    private static final SdkField<List<EntityItem>> ENTITY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entityList").getter(EntitiesDefinition.getter(EntitiesDefinition::entityList)).setter(EntitiesDefinition.setter(Builder::entityList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CEDAR_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cedarJson").getter(EntitiesDefinition.getter(EntitiesDefinition::cedarJson)).setter(EntitiesDefinition.setter(Builder::cedarJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cedarJson").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_LIST_FIELD, CEDAR_JSON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EntitiesDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EntityItem> entityList;
    private final String cedarJson;
    private final Type type;

    private EntitiesDefinition(BuilderImpl builder) {
        this.entityList = builder.entityList;
        this.cedarJson = builder.cedarJson;
        this.type = builder.type;
    }

    public final boolean hasEntityList() {
        return this.entityList != null && !(this.entityList instanceof SdkAutoConstructList);
    }

    public final List<EntityItem> entityList() {
        return this.entityList;
    }

    public final String cedarJson() {
        return this.cedarJson;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityList() ? this.entityList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cedarJson());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitiesDefinition)) {
            return false;
        }
        EntitiesDefinition other = (EntitiesDefinition)obj;
        return this.hasEntityList() == other.hasEntityList() && Objects.equals(this.entityList(), other.entityList()) && Objects.equals(this.cedarJson(), other.cedarJson());
    }

    public final String toString() {
        return ToString.builder((String)"EntitiesDefinition").add("EntityList", this.hasEntityList() ? this.entityList() : null).add("CedarJson", (Object)(this.cedarJson() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityList": {
                return Optional.ofNullable(clazz.cast(this.entityList()));
            }
            case "cedarJson": {
                return Optional.ofNullable(clazz.cast(this.cedarJson()));
            }
        }
        return Optional.empty();
    }

    public static EntitiesDefinition fromEntityList(List<EntityItem> entityList) {
        return (EntitiesDefinition)EntitiesDefinition.builder().entityList(entityList).build();
    }

    public static EntitiesDefinition fromCedarJson(String cedarJson) {
        return (EntitiesDefinition)EntitiesDefinition.builder().cedarJson(cedarJson).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entityList", ENTITY_LIST_FIELD);
        map.put("cedarJson", CEDAR_JSON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EntitiesDefinition, T> g) {
        return obj -> g.apply((EntitiesDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ENTITY_LIST,
        CEDAR_JSON,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<EntityItem> entityList = DefaultSdkAutoConstructList.getInstance();
        private String cedarJson;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EntitiesDefinition model) {
            this.entityList(model.entityList);
            this.cedarJson(model.cedarJson);
        }

        public final List<EntityItem.Builder> getEntityList() {
            List<EntityItem.Builder> result = EntityListCopier.copyToBuilder(this.entityList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityList(Collection<EntityItem.BuilderImpl> entityList) {
            List<EntityItem> oldValue = this.entityList;
            this.entityList = EntityListCopier.copyFromBuilder(entityList);
            this.handleUnionValueChange(Type.ENTITY_LIST, oldValue, this.entityList);
        }

        @Override
        public final Builder entityList(Collection<EntityItem> entityList) {
            List<EntityItem> oldValue = this.entityList;
            this.entityList = EntityListCopier.copy(entityList);
            this.handleUnionValueChange(Type.ENTITY_LIST, oldValue, this.entityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityList(EntityItem ... entityList) {
            this.entityList(Arrays.asList(entityList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityList(Consumer<EntityItem.Builder> ... entityList) {
            this.entityList(Stream.of(entityList).map(c -> (EntityItem)((EntityItem.Builder)EntityItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCedarJson() {
            return this.cedarJson;
        }

        public final void setCedarJson(String cedarJson) {
            String oldValue = this.cedarJson;
            this.cedarJson = cedarJson;
            this.handleUnionValueChange(Type.CEDAR_JSON, oldValue, this.cedarJson);
        }

        @Override
        public final Builder cedarJson(String cedarJson) {
            String oldValue = this.cedarJson;
            this.cedarJson = cedarJson;
            this.handleUnionValueChange(Type.CEDAR_JSON, oldValue, this.cedarJson);
            return this;
        }

        public EntitiesDefinition build() {
            return new EntitiesDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntitiesDefinition> {
        public Builder entityList(Collection<EntityItem> var1);

        public Builder entityList(EntityItem ... var1);

        public Builder entityList(Consumer<EntityItem.Builder> ... var1);

        public Builder cedarJson(String var1);
    }
}

