/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.verifiedpermissions.VerifiedPermissionsAsyncClient;
import software.amazon.awssdk.services.verifiedpermissions.internal.UserAgentUtils;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyStoresRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyStoresResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyStoreItem;

public class ListPolicyStoresPublisher
implements SdkPublisher<ListPolicyStoresResponse> {
    private final VerifiedPermissionsAsyncClient client;
    private final ListPolicyStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyStoresPublisher(VerifiedPermissionsAsyncClient client, ListPolicyStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyStoresPublisher(VerifiedPermissionsAsyncClient client, ListPolicyStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPolicyStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PolicyStoreItem> policyStores() {
        Function<ListPolicyStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyStores() != null) {
                return response.policyStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPolicyStoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPolicyStoresResponseFetcher
    implements AsyncPageFetcher<ListPolicyStoresResponse> {
        private ListPolicyStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPolicyStoresResponse> nextPage(ListPolicyStoresResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyStoresPublisher.this.client.listPolicyStores(ListPolicyStoresPublisher.this.firstRequest);
            }
            return ListPolicyStoresPublisher.this.client.listPolicyStores((ListPolicyStoresRequest)((Object)ListPolicyStoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

