/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.ActionIdentifier;
import software.amazon.awssdk.services.verifiedpermissions.model.ContextDefinition;
import software.amazon.awssdk.services.verifiedpermissions.model.EntitiesDefinition;
import software.amazon.awssdk.services.verifiedpermissions.model.EntityIdentifier;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IsAuthorizedRequest
extends VerifiedPermissionsRequest
implements ToCopyableBuilder<Builder, IsAuthorizedRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(IsAuthorizedRequest.getter(IsAuthorizedRequest::policyStoreId)).setter(IsAuthorizedRequest.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<EntityIdentifier> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("principal").getter(IsAuthorizedRequest.getter(IsAuthorizedRequest::principal)).setter(IsAuthorizedRequest.setter(Builder::principal)).constructor(EntityIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<ActionIdentifier> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("action").getter(IsAuthorizedRequest.getter(IsAuthorizedRequest::action)).setter(IsAuthorizedRequest.setter(Builder::action)).constructor(ActionIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<EntityIdentifier> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(IsAuthorizedRequest.getter(IsAuthorizedRequest::resource)).setter(IsAuthorizedRequest.setter(Builder::resource)).constructor(EntityIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<ContextDefinition> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("context").getter(IsAuthorizedRequest.getter(IsAuthorizedRequest::context)).setter(IsAuthorizedRequest.setter(Builder::context)).constructor(ContextDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()}).build();
    private static final SdkField<EntitiesDefinition> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("entities").getter(IsAuthorizedRequest.getter(IsAuthorizedRequest::entities)).setter(IsAuthorizedRequest.setter(Builder::entities)).constructor(EntitiesDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD, PRINCIPAL_FIELD, ACTION_FIELD, RESOURCE_FIELD, CONTEXT_FIELD, ENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("policyStoreId", POLICY_STORE_ID_FIELD);
            this.put("principal", PRINCIPAL_FIELD);
            this.put("action", ACTION_FIELD);
            this.put("resource", RESOURCE_FIELD);
            this.put("context", CONTEXT_FIELD);
            this.put("entities", ENTITIES_FIELD);
        }
    });
    private final String policyStoreId;
    private final EntityIdentifier principal;
    private final ActionIdentifier action;
    private final EntityIdentifier resource;
    private final ContextDefinition context;
    private final EntitiesDefinition entities;

    private IsAuthorizedRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.principal = builder.principal;
        this.action = builder.action;
        this.resource = builder.resource;
        this.context = builder.context;
        this.entities = builder.entities;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final EntityIdentifier principal() {
        return this.principal;
    }

    public final ActionIdentifier action() {
        return this.action;
    }

    public final EntityIdentifier resource() {
        return this.resource;
    }

    public final ContextDefinition context() {
        return this.context;
    }

    public final EntitiesDefinition entities() {
        return this.entities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.entities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsAuthorizedRequest)) {
            return false;
        }
        IsAuthorizedRequest other = (IsAuthorizedRequest)((Object)obj);
        return Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.context(), other.context()) && Objects.equals(this.entities(), other.entities());
    }

    public final String toString() {
        return ToString.builder((String)"IsAuthorizedRequest").add("PolicyStoreId", (Object)this.policyStoreId()).add("Principal", (Object)this.principal()).add("Action", (Object)this.action()).add("Resource", (Object)this.resource()).add("Context", (Object)this.context()).add("Entities", (Object)this.entities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IsAuthorizedRequest, T> g) {
        return obj -> g.apply((IsAuthorizedRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsRequest.BuilderImpl
    implements Builder {
        private String policyStoreId;
        private EntityIdentifier principal;
        private ActionIdentifier action;
        private EntityIdentifier resource;
        private ContextDefinition context;
        private EntitiesDefinition entities;

        private BuilderImpl() {
        }

        private BuilderImpl(IsAuthorizedRequest model) {
            super(model);
            this.policyStoreId(model.policyStoreId);
            this.principal(model.principal);
            this.action(model.action);
            this.resource(model.resource);
            this.context(model.context);
            this.entities(model.entities);
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final EntityIdentifier.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        public final void setPrincipal(EntityIdentifier.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(EntityIdentifier principal) {
            this.principal = principal;
            return this;
        }

        public final ActionIdentifier.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(ActionIdentifier.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ActionIdentifier action) {
            this.action = action;
            return this;
        }

        public final EntityIdentifier.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(EntityIdentifier.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(EntityIdentifier resource) {
            this.resource = resource;
            return this;
        }

        public final ContextDefinition.Builder getContext() {
            return this.context != null ? this.context.toBuilder() : null;
        }

        public final void setContext(ContextDefinition.BuilderImpl context) {
            this.context = context != null ? context.build() : null;
        }

        @Override
        public final Builder context(ContextDefinition context) {
            this.context = context;
            return this;
        }

        public final EntitiesDefinition.Builder getEntities() {
            return this.entities != null ? this.entities.toBuilder() : null;
        }

        public final void setEntities(EntitiesDefinition.BuilderImpl entities) {
            this.entities = entities != null ? entities.build() : null;
        }

        @Override
        public final Builder entities(EntitiesDefinition entities) {
            this.entities = entities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IsAuthorizedRequest build() {
            return new IsAuthorizedRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, IsAuthorizedRequest> {
        public Builder policyStoreId(String var1);

        public Builder principal(EntityIdentifier var1);

        default public Builder principal(Consumer<EntityIdentifier.Builder> principal) {
            return this.principal((EntityIdentifier)((EntityIdentifier.Builder)EntityIdentifier.builder().applyMutation(principal)).build());
        }

        public Builder action(ActionIdentifier var1);

        default public Builder action(Consumer<ActionIdentifier.Builder> action) {
            return this.action((ActionIdentifier)((ActionIdentifier.Builder)ActionIdentifier.builder().applyMutation(action)).build());
        }

        public Builder resource(EntityIdentifier var1);

        default public Builder resource(Consumer<EntityIdentifier.Builder> resource) {
            return this.resource((EntityIdentifier)((EntityIdentifier.Builder)EntityIdentifier.builder().applyMutation(resource)).build());
        }

        public Builder context(ContextDefinition var1);

        default public Builder context(Consumer<ContextDefinition.Builder> context) {
            return this.context((ContextDefinition)((ContextDefinition.Builder)ContextDefinition.builder().applyMutation(context)).build());
        }

        public Builder entities(EntitiesDefinition var1);

        default public Builder entities(Consumer<EntitiesDefinition.Builder> entities) {
            return this.entities((EntitiesDefinition)((EntitiesDefinition.Builder)EntitiesDefinition.builder().applyMutation(entities)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

