/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyInputItem;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchGetPolicyInputListCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetPolicyRequest
extends VerifiedPermissionsRequest
implements ToCopyableBuilder<Builder, BatchGetPolicyRequest> {
    private static final SdkField<List<BatchGetPolicyInputItem>> REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requests").getter(BatchGetPolicyRequest.getter(BatchGetPolicyRequest::requests)).setter(BatchGetPolicyRequest.setter(Builder::requests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetPolicyInputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("requests", REQUESTS_FIELD);
        }
    });
    private final List<BatchGetPolicyInputItem> requests;

    private BatchGetPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.requests = builder.requests;
    }

    public final boolean hasRequests() {
        return this.requests != null && !(this.requests instanceof SdkAutoConstructList);
    }

    public final List<BatchGetPolicyInputItem> requests() {
        return this.requests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequests() ? this.requests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPolicyRequest)) {
            return false;
        }
        BatchGetPolicyRequest other = (BatchGetPolicyRequest)((Object)obj);
        return this.hasRequests() == other.hasRequests() && Objects.equals(this.requests(), other.requests());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetPolicyRequest").add("Requests", this.hasRequests() ? this.requests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requests": {
                return Optional.ofNullable(clazz.cast(this.requests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPolicyRequest, T> g) {
        return obj -> g.apply((BatchGetPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsRequest.BuilderImpl
    implements Builder {
        private List<BatchGetPolicyInputItem> requests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPolicyRequest model) {
            super(model);
            this.requests(model.requests);
        }

        public final List<BatchGetPolicyInputItem.Builder> getRequests() {
            List<BatchGetPolicyInputItem.Builder> result = BatchGetPolicyInputListCopier.copyToBuilder(this.requests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequests(Collection<BatchGetPolicyInputItem.BuilderImpl> requests) {
            this.requests = BatchGetPolicyInputListCopier.copyFromBuilder(requests);
        }

        @Override
        public final Builder requests(Collection<BatchGetPolicyInputItem> requests) {
            this.requests = BatchGetPolicyInputListCopier.copy(requests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(BatchGetPolicyInputItem ... requests) {
            this.requests(Arrays.asList(requests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(Consumer<BatchGetPolicyInputItem.Builder> ... requests) {
            this.requests(Stream.of(requests).map(c -> (BatchGetPolicyInputItem)((BatchGetPolicyInputItem.Builder)BatchGetPolicyInputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetPolicyRequest build() {
            return new BatchGetPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetPolicyRequest> {
        public Builder requests(Collection<BatchGetPolicyInputItem> var1);

        public Builder requests(BatchGetPolicyInputItem ... var1);

        public Builder requests(Consumer<BatchGetPolicyInputItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

