/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyDefinitionDetail;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetPolicyOutputItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetPolicyOutputItem> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(BatchGetPolicyOutputItem.getter(BatchGetPolicyOutputItem::policyStoreId)).setter(BatchGetPolicyOutputItem.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyId").getter(BatchGetPolicyOutputItem.getter(BatchGetPolicyOutputItem::policyId)).setter(BatchGetPolicyOutputItem.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyId").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyType").getter(BatchGetPolicyOutputItem.getter(BatchGetPolicyOutputItem::policyTypeAsString)).setter(BatchGetPolicyOutputItem.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()}).build();
    private static final SdkField<PolicyDefinitionDetail> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(BatchGetPolicyOutputItem.getter(BatchGetPolicyOutputItem::definition)).setter(BatchGetPolicyOutputItem.setter(Builder::definition)).constructor(PolicyDefinitionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(BatchGetPolicyOutputItem.getter(BatchGetPolicyOutputItem::createdDate)).setter(BatchGetPolicyOutputItem.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDate").getter(BatchGetPolicyOutputItem.getter(BatchGetPolicyOutputItem::lastUpdatedDate)).setter(BatchGetPolicyOutputItem.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD, POLICY_ID_FIELD, POLICY_TYPE_FIELD, DEFINITION_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("policyStoreId", POLICY_STORE_ID_FIELD);
            this.put("policyId", POLICY_ID_FIELD);
            this.put("policyType", POLICY_TYPE_FIELD);
            this.put("definition", DEFINITION_FIELD);
            this.put("createdDate", CREATED_DATE_FIELD);
            this.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String policyStoreId;
    private final String policyId;
    private final String policyType;
    private final PolicyDefinitionDetail definition;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;

    private BatchGetPolicyOutputItem(BuilderImpl builder) {
        this.policyStoreId = builder.policyStoreId;
        this.policyId = builder.policyId;
        this.policyType = builder.policyType;
        this.definition = builder.definition;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final PolicyDefinitionDetail definition() {
        return this.definition;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPolicyOutputItem)) {
            return false;
        }
        BatchGetPolicyOutputItem other = (BatchGetPolicyOutputItem)obj;
        return Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetPolicyOutputItem").add("PolicyStoreId", (Object)this.policyStoreId()).add("PolicyId", (Object)this.policyId()).add("PolicyType", (Object)this.policyTypeAsString()).add("Definition", (Object)this.definition()).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "policyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "policyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPolicyOutputItem, T> g) {
        return obj -> g.apply((BatchGetPolicyOutputItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyStoreId;
        private String policyId;
        private String policyType;
        private PolicyDefinitionDetail definition;
        private Instant createdDate;
        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPolicyOutputItem model) {
            this.policyStoreId(model.policyStoreId);
            this.policyId(model.policyId);
            this.policyType(model.policyType);
            this.definition(model.definition);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final PolicyDefinitionDetail.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(PolicyDefinitionDetail.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PolicyDefinitionDetail definition) {
            this.definition = definition;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public BatchGetPolicyOutputItem build() {
            return new BatchGetPolicyOutputItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetPolicyOutputItem> {
        public Builder policyStoreId(String var1);

        public Builder policyId(String var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder definition(PolicyDefinitionDetail var1);

        default public Builder definition(Consumer<PolicyDefinitionDetail.Builder> definition) {
            return this.definition((PolicyDefinitionDetail)((PolicyDefinitionDetail.Builder)PolicyDefinitionDetail.builder().applyMutation(definition)).build());
        }

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);
    }
}

