/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.ClientIdsCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.CognitoGroupConfigurationItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CognitoUserPoolConfigurationItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CognitoUserPoolConfigurationItem> {
    private static final SdkField<String> USER_POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userPoolArn").getter(CognitoUserPoolConfigurationItem.getter(CognitoUserPoolConfigurationItem::userPoolArn)).setter(CognitoUserPoolConfigurationItem.setter(Builder::userPoolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolArn").build()}).build();
    private static final SdkField<List<String>> CLIENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clientIds").getter(CognitoUserPoolConfigurationItem.getter(CognitoUserPoolConfigurationItem::clientIds)).setter(CognitoUserPoolConfigurationItem.setter(Builder::clientIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuer").getter(CognitoUserPoolConfigurationItem.getter(CognitoUserPoolConfigurationItem::issuer)).setter(CognitoUserPoolConfigurationItem.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<CognitoGroupConfigurationItem> GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groupConfiguration").getter(CognitoUserPoolConfigurationItem.getter(CognitoUserPoolConfigurationItem::groupConfiguration)).setter(CognitoUserPoolConfigurationItem.setter(Builder::groupConfiguration)).constructor(CognitoGroupConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ARN_FIELD, CLIENT_IDS_FIELD, ISSUER_FIELD, GROUP_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("userPoolArn", USER_POOL_ARN_FIELD);
            this.put("clientIds", CLIENT_IDS_FIELD);
            this.put("issuer", ISSUER_FIELD);
            this.put("groupConfiguration", GROUP_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String userPoolArn;
    private final List<String> clientIds;
    private final String issuer;
    private final CognitoGroupConfigurationItem groupConfiguration;

    private CognitoUserPoolConfigurationItem(BuilderImpl builder) {
        this.userPoolArn = builder.userPoolArn;
        this.clientIds = builder.clientIds;
        this.issuer = builder.issuer;
        this.groupConfiguration = builder.groupConfiguration;
    }

    public final String userPoolArn() {
        return this.userPoolArn;
    }

    public final boolean hasClientIds() {
        return this.clientIds != null && !(this.clientIds instanceof SdkAutoConstructList);
    }

    public final List<String> clientIds() {
        return this.clientIds;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final CognitoGroupConfigurationItem groupConfiguration() {
        return this.groupConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientIds() ? this.clientIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoUserPoolConfigurationItem)) {
            return false;
        }
        CognitoUserPoolConfigurationItem other = (CognitoUserPoolConfigurationItem)obj;
        return Objects.equals(this.userPoolArn(), other.userPoolArn()) && this.hasClientIds() == other.hasClientIds() && Objects.equals(this.clientIds(), other.clientIds()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.groupConfiguration(), other.groupConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CognitoUserPoolConfigurationItem").add("UserPoolArn", (Object)this.userPoolArn()).add("ClientIds", (Object)(this.clientIds() == null ? null : "*** Sensitive Data Redacted ***")).add("Issuer", (Object)this.issuer()).add("GroupConfiguration", (Object)this.groupConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userPoolArn": {
                return Optional.ofNullable(clazz.cast(this.userPoolArn()));
            }
            case "clientIds": {
                return Optional.ofNullable(clazz.cast(this.clientIds()));
            }
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "groupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.groupConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CognitoUserPoolConfigurationItem, T> g) {
        return obj -> g.apply((CognitoUserPoolConfigurationItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolArn;
        private List<String> clientIds = DefaultSdkAutoConstructList.getInstance();
        private String issuer;
        private CognitoGroupConfigurationItem groupConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoUserPoolConfigurationItem model) {
            this.userPoolArn(model.userPoolArn);
            this.clientIds(model.clientIds);
            this.issuer(model.issuer);
            this.groupConfiguration(model.groupConfiguration);
        }

        public final String getUserPoolArn() {
            return this.userPoolArn;
        }

        public final void setUserPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
        }

        @Override
        public final Builder userPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
            return this;
        }

        public final Collection<String> getClientIds() {
            if (this.clientIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientIds;
        }

        public final void setClientIds(Collection<String> clientIds) {
            this.clientIds = ClientIdsCopier.copy(clientIds);
        }

        @Override
        public final Builder clientIds(Collection<String> clientIds) {
            this.clientIds = ClientIdsCopier.copy(clientIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIds(String ... clientIds) {
            this.clientIds(Arrays.asList(clientIds));
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final CognitoGroupConfigurationItem.Builder getGroupConfiguration() {
            return this.groupConfiguration != null ? this.groupConfiguration.toBuilder() : null;
        }

        public final void setGroupConfiguration(CognitoGroupConfigurationItem.BuilderImpl groupConfiguration) {
            this.groupConfiguration = groupConfiguration != null ? groupConfiguration.build() : null;
        }

        @Override
        public final Builder groupConfiguration(CognitoGroupConfigurationItem groupConfiguration) {
            this.groupConfiguration = groupConfiguration;
            return this;
        }

        public CognitoUserPoolConfigurationItem build() {
            return new CognitoUserPoolConfigurationItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CognitoUserPoolConfigurationItem> {
        public Builder userPoolArn(String var1);

        public Builder clientIds(Collection<String> var1);

        public Builder clientIds(String ... var1);

        public Builder issuer(String var1);

        public Builder groupConfiguration(CognitoGroupConfigurationItem var1);

        default public Builder groupConfiguration(Consumer<CognitoGroupConfigurationItem.Builder> groupConfiguration) {
            return this.groupConfiguration((CognitoGroupConfigurationItem)((CognitoGroupConfigurationItem.Builder)CognitoGroupConfigurationItem.builder().applyMutation(groupConfiguration)).build());
        }
    }
}

