/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyStoreItem;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyStoreListCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPolicyStoresResponse
extends VerifiedPermissionsResponse
implements ToCopyableBuilder<Builder, ListPolicyStoresResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPolicyStoresResponse.getter(ListPolicyStoresResponse::nextToken)).setter(ListPolicyStoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PolicyStoreItem>> POLICY_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyStores").getter(ListPolicyStoresResponse.getter(ListPolicyStoresResponse::policyStores)).setter(ListPolicyStoresResponse.setter(Builder::policyStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyStoreItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, POLICY_STORES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("policyStores", POLICY_STORES_FIELD);
        }
    });
    private final String nextToken;
    private final List<PolicyStoreItem> policyStores;

    private ListPolicyStoresResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.policyStores = builder.policyStores;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPolicyStores() {
        return this.policyStores != null && !(this.policyStores instanceof SdkAutoConstructList);
    }

    public final List<PolicyStoreItem> policyStores() {
        return this.policyStores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyStores() ? this.policyStores() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyStoresResponse)) {
            return false;
        }
        ListPolicyStoresResponse other = (ListPolicyStoresResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPolicyStores() == other.hasPolicyStores() && Objects.equals(this.policyStores(), other.policyStores());
    }

    public final String toString() {
        return ToString.builder((String)"ListPolicyStoresResponse").add("NextToken", (Object)this.nextToken()).add("PolicyStores", this.hasPolicyStores() ? this.policyStores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "policyStores": {
                return Optional.ofNullable(clazz.cast(this.policyStores()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyStoresResponse, T> g) {
        return obj -> g.apply((ListPolicyStoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PolicyStoreItem> policyStores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyStoresResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.policyStores(model.policyStores);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PolicyStoreItem.Builder> getPolicyStores() {
            List<PolicyStoreItem.Builder> result = PolicyStoreListCopier.copyToBuilder(this.policyStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyStores(Collection<PolicyStoreItem.BuilderImpl> policyStores) {
            this.policyStores = PolicyStoreListCopier.copyFromBuilder(policyStores);
        }

        @Override
        public final Builder policyStores(Collection<PolicyStoreItem> policyStores) {
            this.policyStores = PolicyStoreListCopier.copy(policyStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyStores(PolicyStoreItem ... policyStores) {
            this.policyStores(Arrays.asList(policyStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyStores(Consumer<PolicyStoreItem.Builder> ... policyStores) {
            this.policyStores(Stream.of(policyStores).map(c -> (PolicyStoreItem)((PolicyStoreItem.Builder)PolicyStoreItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPolicyStoresResponse build() {
            return new ListPolicyStoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPolicyStoresResponse> {
        public Builder nextToken(String var1);

        public Builder policyStores(Collection<PolicyStoreItem> var1);

        public Builder policyStores(PolicyStoreItem ... var1);

        public Builder policyStores(Consumer<PolicyStoreItem.Builder> ... var1);
    }
}

