/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentitySourcesResponse extends VerifiedPermissionsResponse implements
        ToCopyableBuilder<ListIdentitySourcesResponse.Builder, ListIdentitySourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIdentitySourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<IdentitySourceItem>> IDENTITY_SOURCES_FIELD = SdkField
            .<List<IdentitySourceItem>> builder(MarshallingType.LIST)
            .memberName("identitySources")
            .getter(getter(ListIdentitySourcesResponse::identitySources))
            .setter(setter(Builder::identitySources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identitySources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentitySourceItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentitySourceItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            IDENTITY_SOURCES_FIELD));

    private final String nextToken;

    private final List<IdentitySourceItem> identitySources;

    private ListIdentitySourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.identitySources = builder.identitySources;
    }

    /**
     * <p>
     * If present, this value indicates that more output is available than is included in the current response. Use this
     * value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part
     * of the output. You should repeat this until the <code>NextToken</code> response element comes back as
     * <code>null</code>. This indicates that this is the last page of results.
     * </p>
     * 
     * @return If present, this value indicates that more output is available than is included in the current response.
     *         Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to
     *         get the next part of the output. You should repeat this until the <code>NextToken</code> response element
     *         comes back as <code>null</code>. This indicates that this is the last page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentitySources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIdentitySources() {
        return identitySources != null && !(identitySources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of identity sources stored in the specified policy store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentitySources} method.
     * </p>
     * 
     * @return The list of identity sources stored in the specified policy store.
     */
    public final List<IdentitySourceItem> identitySources() {
        return identitySources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentitySources() ? identitySources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitySourcesResponse)) {
            return false;
        }
        ListIdentitySourcesResponse other = (ListIdentitySourcesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasIdentitySources() == other.hasIdentitySources()
                && Objects.equals(identitySources(), other.identitySources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIdentitySourcesResponse").add("NextToken", nextToken())
                .add("IdentitySources", hasIdentitySources() ? identitySources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "identitySources":
            return Optional.ofNullable(clazz.cast(identitySources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentitySourcesResponse, T> g) {
        return obj -> g.apply((ListIdentitySourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIdentitySourcesResponse> {
        /**
         * <p>
         * If present, this value indicates that more output is available than is included in the current response. Use
         * this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         * next part of the output. You should repeat this until the <code>NextToken</code> response element comes back
         * as <code>null</code>. This indicates that this is the last page of results.
         * </p>
         * 
         * @param nextToken
         *        If present, this value indicates that more output is available than is included in the current
         *        response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         *        operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         *        response element comes back as <code>null</code>. This indicates that this is the last page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of identity sources stored in the specified policy store.
         * </p>
         * 
         * @param identitySources
         *        The list of identity sources stored in the specified policy store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySources(Collection<IdentitySourceItem> identitySources);

        /**
         * <p>
         * The list of identity sources stored in the specified policy store.
         * </p>
         * 
         * @param identitySources
         *        The list of identity sources stored in the specified policy store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySources(IdentitySourceItem... identitySources);

        /**
         * <p>
         * The list of identity sources stored in the specified policy store.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.IdentitySourceItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.IdentitySourceItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.IdentitySourceItem.Builder#build()} is
         * called immediately and its result is passed to {@link #identitySources(List<IdentitySourceItem>)}.
         * 
         * @param identitySources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.IdentitySourceItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identitySources(java.util.Collection<IdentitySourceItem>)
         */
        Builder identitySources(Consumer<IdentitySourceItem.Builder>... identitySources);
    }

    static final class BuilderImpl extends VerifiedPermissionsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<IdentitySourceItem> identitySources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitySourcesResponse model) {
            super(model);
            nextToken(model.nextToken);
            identitySources(model.identitySources);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IdentitySourceItem.Builder> getIdentitySources() {
            List<IdentitySourceItem.Builder> result = IdentitySourcesCopier.copyToBuilder(this.identitySources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentitySources(Collection<IdentitySourceItem.BuilderImpl> identitySources) {
            this.identitySources = IdentitySourcesCopier.copyFromBuilder(identitySources);
        }

        @Override
        public final Builder identitySources(Collection<IdentitySourceItem> identitySources) {
            this.identitySources = IdentitySourcesCopier.copy(identitySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identitySources(IdentitySourceItem... identitySources) {
            identitySources(Arrays.asList(identitySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identitySources(Consumer<IdentitySourceItem.Builder>... identitySources) {
            identitySources(Stream.of(identitySources).map(c -> IdentitySourceItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListIdentitySourcesResponse build() {
            return new ListIdentitySourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
