/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.ConfigurationItem;
import software.amazon.awssdk.services.verifiedpermissions.model.IdentitySourceItemDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentitySourceItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentitySourceItem> {
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(IdentitySourceItem.getter(IdentitySourceItem::createdDate)).setter(IdentitySourceItem.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<IdentitySourceItemDetails> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("details").getter(IdentitySourceItem.getter(IdentitySourceItem::details)).setter(IdentitySourceItem.setter(Builder::details)).constructor(IdentitySourceItemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()}).build();
    private static final SdkField<String> IDENTITY_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identitySourceId").getter(IdentitySourceItem.getter(IdentitySourceItem::identitySourceId)).setter(IdentitySourceItem.setter(Builder::identitySourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identitySourceId").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDate").getter(IdentitySourceItem.getter(IdentitySourceItem::lastUpdatedDate)).setter(IdentitySourceItem.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(IdentitySourceItem.getter(IdentitySourceItem::policyStoreId)).setter(IdentitySourceItem.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<String> PRINCIPAL_ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalEntityType").getter(IdentitySourceItem.getter(IdentitySourceItem::principalEntityType)).setter(IdentitySourceItem.setter(Builder::principalEntityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalEntityType").build()}).build();
    private static final SdkField<ConfigurationItem> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(IdentitySourceItem.getter(IdentitySourceItem::configuration)).setter(IdentitySourceItem.setter(Builder::configuration)).constructor(ConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD, DETAILS_FIELD, IDENTITY_SOURCE_ID_FIELD, LAST_UPDATED_DATE_FIELD, POLICY_STORE_ID_FIELD, PRINCIPAL_ENTITY_TYPE_FIELD, CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdDate;
    private final IdentitySourceItemDetails details;
    private final String identitySourceId;
    private final Instant lastUpdatedDate;
    private final String policyStoreId;
    private final String principalEntityType;
    private final ConfigurationItem configuration;

    private IdentitySourceItem(BuilderImpl builder) {
        this.createdDate = builder.createdDate;
        this.details = builder.details;
        this.identitySourceId = builder.identitySourceId;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.policyStoreId = builder.policyStoreId;
        this.principalEntityType = builder.principalEntityType;
        this.configuration = builder.configuration;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    @Deprecated
    public final IdentitySourceItemDetails details() {
        return this.details;
    }

    public final String identitySourceId() {
        return this.identitySourceId;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final String principalEntityType() {
        return this.principalEntityType;
    }

    public final ConfigurationItem configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.identitySourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalEntityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentitySourceItem)) {
            return false;
        }
        IdentitySourceItem other = (IdentitySourceItem)obj;
        return Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.details(), other.details()) && Objects.equals(this.identitySourceId(), other.identitySourceId()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.principalEntityType(), other.principalEntityType()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"IdentitySourceItem").add("CreatedDate", (Object)this.createdDate()).add("Details", (Object)this.details()).add("IdentitySourceId", (Object)this.identitySourceId()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("PolicyStoreId", (Object)this.policyStoreId()).add("PrincipalEntityType", (Object)(this.principalEntityType() == null ? null : "*** Sensitive Data Redacted ***")).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "identitySourceId": {
                return Optional.ofNullable(clazz.cast(this.identitySourceId()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "principalEntityType": {
                return Optional.ofNullable(clazz.cast(this.principalEntityType()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentitySourceItem, T> g) {
        return obj -> g.apply((IdentitySourceItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdDate;
        private IdentitySourceItemDetails details;
        private String identitySourceId;
        private Instant lastUpdatedDate;
        private String policyStoreId;
        private String principalEntityType;
        private ConfigurationItem configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentitySourceItem model) {
            this.createdDate(model.createdDate);
            this.details(model.details);
            this.identitySourceId(model.identitySourceId);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.policyStoreId(model.policyStoreId);
            this.principalEntityType(model.principalEntityType);
            this.configuration(model.configuration);
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Deprecated
        public final IdentitySourceItemDetails.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        @Deprecated
        public final void setDetails(IdentitySourceItemDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        @Deprecated
        public final Builder details(IdentitySourceItemDetails details) {
            this.details = details;
            return this;
        }

        public final String getIdentitySourceId() {
            return this.identitySourceId;
        }

        public final void setIdentitySourceId(String identitySourceId) {
            this.identitySourceId = identitySourceId;
        }

        @Override
        public final Builder identitySourceId(String identitySourceId) {
            this.identitySourceId = identitySourceId;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPrincipalEntityType() {
            return this.principalEntityType;
        }

        public final void setPrincipalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
        }

        @Override
        public final Builder principalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
            return this;
        }

        public final ConfigurationItem.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ConfigurationItem.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ConfigurationItem configuration) {
            this.configuration = configuration;
            return this;
        }

        public IdentitySourceItem build() {
            return new IdentitySourceItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentitySourceItem> {
        public Builder createdDate(Instant var1);

        @Deprecated
        public Builder details(IdentitySourceItemDetails var1);

        @Deprecated
        default public Builder details(Consumer<IdentitySourceItemDetails.Builder> details) {
            return this.details((IdentitySourceItemDetails)((IdentitySourceItemDetails.Builder)IdentitySourceItemDetails.builder().applyMutation(details)).build());
        }

        public Builder identitySourceId(String var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder policyStoreId(String var1);

        public Builder principalEntityType(String var1);

        public Builder configuration(ConfigurationItem var1);

        default public Builder configuration(Consumer<ConfigurationItem.Builder> configuration) {
            return this.configuration((ConfigurationItem)((ConfigurationItem.Builder)ConfigurationItem.builder().applyMutation(configuration)).build());
        }
    }
}

