/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.verifiedpermissions.model.AttributeValue;
import software.amazon.awssdk.services.verifiedpermissions.model.ContextMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContextDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContextDefinition> {
    private static final SdkField<Map<String, AttributeValue>> CONTEXT_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("contextMap").getter(ContextDefinition.getter(ContextDefinition::contextMap)).setter(ContextDefinition.setter(Builder::contextMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeValue> contextMap;
    private final Type type;

    private ContextDefinition(BuilderImpl builder) {
        this.contextMap = builder.contextMap;
        this.type = builder.type;
    }

    public final boolean hasContextMap() {
        return this.contextMap != null && !(this.contextMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> contextMap() {
        return this.contextMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContextMap() ? this.contextMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextDefinition)) {
            return false;
        }
        ContextDefinition other = (ContextDefinition)obj;
        return this.hasContextMap() == other.hasContextMap() && Objects.equals(this.contextMap(), other.contextMap());
    }

    public final String toString() {
        return ToString.builder((String)"ContextDefinition").add("ContextMap", (Object)(this.contextMap() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contextMap": {
                return Optional.ofNullable(clazz.cast(this.contextMap()));
            }
        }
        return Optional.empty();
    }

    public static ContextDefinition fromContextMap(Map<String, AttributeValue> contextMap) {
        return (ContextDefinition)ContextDefinition.builder().contextMap(contextMap).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContextDefinition, T> g) {
        return obj -> g.apply((ContextDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONTEXT_MAP,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> contextMap = DefaultSdkAutoConstructMap.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContextDefinition model) {
            this.contextMap(model.contextMap);
        }

        public final Map<String, AttributeValue.Builder> getContextMap() {
            Map<String, AttributeValue.Builder> result = ContextMapCopier.copyToBuilder(this.contextMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setContextMap(Map<String, AttributeValue.BuilderImpl> contextMap) {
            Map<String, AttributeValue> oldValue = this.contextMap;
            this.contextMap = ContextMapCopier.copyFromBuilder(contextMap);
            this.handleUnionValueChange(Type.CONTEXT_MAP, oldValue, this.contextMap);
        }

        @Override
        public final Builder contextMap(Map<String, AttributeValue> contextMap) {
            Map<String, AttributeValue> oldValue = this.contextMap;
            this.contextMap = ContextMapCopier.copy(contextMap);
            this.handleUnionValueChange(Type.CONTEXT_MAP, oldValue, this.contextMap);
            return this;
        }

        public ContextDefinition build() {
            return new ContextDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContextDefinition> {
        public Builder contextMap(Map<String, AttributeValue> var1);
    }
}

