/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.verifiedpermissions.VerifiedPermissionsClient;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyStoresRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyStoresResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyStoreItem;

public class ListPolicyStoresIterable
implements SdkIterable<ListPolicyStoresResponse> {
    private final VerifiedPermissionsClient client;
    private final ListPolicyStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyStoresIterable(VerifiedPermissionsClient client, ListPolicyStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPolicyStoresResponseFetcher();
    }

    public Iterator<ListPolicyStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PolicyStoreItem> policyStores() {
        Function<ListPolicyStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyStores() != null) {
                return response.policyStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPolicyStoresResponseFetcher
    implements SyncPageFetcher<ListPolicyStoresResponse> {
        private ListPolicyStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPolicyStoresResponse nextPage(ListPolicyStoresResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyStoresIterable.this.client.listPolicyStores(ListPolicyStoresIterable.this.firstRequest);
            }
            return ListPolicyStoresIterable.this.client.listPolicyStores((ListPolicyStoresRequest)((Object)ListPolicyStoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

