/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.verifiedpermissions.VerifiedPermissionsClient;
import software.amazon.awssdk.services.verifiedpermissions.VerifiedPermissionsServiceClientConfiguration;
import software.amazon.awssdk.services.verifiedpermissions.model.AccessDeniedException;
import software.amazon.awssdk.services.verifiedpermissions.model.ConflictException;
import software.amazon.awssdk.services.verifiedpermissions.model.CreateIdentitySourceRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.CreateIdentitySourceResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.CreatePolicyRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.CreatePolicyResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.CreatePolicyStoreRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.CreatePolicyStoreResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.CreatePolicyTemplateRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.CreatePolicyTemplateResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.DeleteIdentitySourceRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.DeleteIdentitySourceResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.DeletePolicyRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.DeletePolicyResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.DeletePolicyStoreRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.DeletePolicyStoreResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.DeletePolicyTemplateRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.DeletePolicyTemplateResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.GetIdentitySourceRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.GetIdentitySourceResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.GetPolicyRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.GetPolicyResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.GetPolicyStoreRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.GetPolicyStoreResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.GetPolicyTemplateRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.GetPolicyTemplateResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.GetSchemaRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.GetSchemaResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.InternalServerException;
import software.amazon.awssdk.services.verifiedpermissions.model.IsAuthorizedRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.IsAuthorizedResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.IsAuthorizedWithTokenRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.IsAuthorizedWithTokenResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.ListIdentitySourcesRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.ListIdentitySourcesResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPoliciesRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPoliciesResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyStoresRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyStoresResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyTemplatesRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyTemplatesResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.PutSchemaRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.PutSchemaResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.ResourceNotFoundException;
import software.amazon.awssdk.services.verifiedpermissions.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.verifiedpermissions.model.ThrottlingException;
import software.amazon.awssdk.services.verifiedpermissions.model.UpdateIdentitySourceRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.UpdateIdentitySourceResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.UpdatePolicyRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.UpdatePolicyResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.UpdatePolicyStoreRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.UpdatePolicyStoreResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.UpdatePolicyTemplateRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.UpdatePolicyTemplateResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.ValidationException;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsException;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsRequest;
import software.amazon.awssdk.services.verifiedpermissions.paginators.ListIdentitySourcesIterable;
import software.amazon.awssdk.services.verifiedpermissions.paginators.ListPoliciesIterable;
import software.amazon.awssdk.services.verifiedpermissions.paginators.ListPolicyStoresIterable;
import software.amazon.awssdk.services.verifiedpermissions.paginators.ListPolicyTemplatesIterable;
import software.amazon.awssdk.services.verifiedpermissions.transform.CreateIdentitySourceRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.CreatePolicyStoreRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.CreatePolicyTemplateRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.DeleteIdentitySourceRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.DeletePolicyStoreRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.DeletePolicyTemplateRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.GetIdentitySourceRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.GetPolicyStoreRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.GetPolicyTemplateRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.GetSchemaRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.IsAuthorizedRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.IsAuthorizedWithTokenRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.ListIdentitySourcesRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.ListPolicyStoresRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.ListPolicyTemplatesRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.PutSchemaRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.UpdateIdentitySourceRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.UpdatePolicyRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.UpdatePolicyStoreRequestMarshaller;
import software.amazon.awssdk.services.verifiedpermissions.transform.UpdatePolicyTemplateRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultVerifiedPermissionsClient
implements VerifiedPermissionsClient {
    private static final Logger log = Logger.loggerFor(DefaultVerifiedPermissionsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final VerifiedPermissionsServiceClientConfiguration serviceClientConfiguration;

    protected DefaultVerifiedPermissionsClient(VerifiedPermissionsServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIdentitySourceResponse createIdentitySource(CreateIdentitySourceRequest createIdentitySourceRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIdentitySourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, createIdentitySourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIdentitySource");
            CreateIdentitySourceResponse createIdentitySourceResponse = (CreateIdentitySourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIdentitySource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIdentitySourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIdentitySourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIdentitySourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$createIdentitySource$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePolicyResponse createPolicy(CreatePolicyRequest createPolicyRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, createPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePolicy");
            CreatePolicyResponse createPolicyResponse = (CreatePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$createPolicy$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePolicyStoreResponse createPolicyStore(CreatePolicyStoreRequest createPolicyStoreRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePolicyStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, createPolicyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePolicyStore");
            CreatePolicyStoreResponse createPolicyStoreResponse = (CreatePolicyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePolicyStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPolicyStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePolicyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPolicyStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$createPolicyStore$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePolicyTemplateResponse createPolicyTemplate(CreatePolicyTemplateRequest createPolicyTemplateRequest) throws ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePolicyTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, createPolicyTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePolicyTemplate");
            CreatePolicyTemplateResponse createPolicyTemplateResponse = (CreatePolicyTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePolicyTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPolicyTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePolicyTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPolicyTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$createPolicyTemplate$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIdentitySourceResponse deleteIdentitySource(DeleteIdentitySourceRequest deleteIdentitySourceRequest) throws ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIdentitySourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, deleteIdentitySourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentitySource");
            DeleteIdentitySourceResponse deleteIdentitySourceResponse = (DeleteIdentitySourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentitySource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIdentitySourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIdentitySourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIdentitySourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$deleteIdentitySource$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, deletePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePolicy");
            DeletePolicyResponse deletePolicyResponse = (DeletePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$deletePolicy$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePolicyStoreResponse deletePolicyStore(DeletePolicyStoreRequest deletePolicyStoreRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePolicyStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, deletePolicyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePolicyStore");
            DeletePolicyStoreResponse deletePolicyStoreResponse = (DeletePolicyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicyStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePolicyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePolicyStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$deletePolicyStore$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePolicyTemplateResponse deletePolicyTemplate(DeletePolicyTemplateRequest deletePolicyTemplateRequest) throws ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePolicyTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, deletePolicyTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePolicyTemplate");
            DeletePolicyTemplateResponse deletePolicyTemplateResponse = (DeletePolicyTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicyTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePolicyTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePolicyTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$deletePolicyTemplate$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentitySourceResponse getIdentitySource(GetIdentitySourceRequest getIdentitySourceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIdentitySourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, getIdentitySourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentitySource");
            GetIdentitySourceResponse getIdentitySourceResponse = (GetIdentitySourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentitySource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentitySourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdentitySourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIdentitySourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$getIdentitySource$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, getPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPolicy");
            GetPolicyResponse getPolicyResponse = (GetPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$getPolicy$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPolicyStoreResponse getPolicyStore(GetPolicyStoreRequest getPolicyStoreRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPolicyStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, getPolicyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPolicyStore");
            GetPolicyStoreResponse getPolicyStoreResponse = (GetPolicyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPolicyStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPolicyStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPolicyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPolicyStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$getPolicyStore$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPolicyTemplateResponse getPolicyTemplate(GetPolicyTemplateRequest getPolicyTemplateRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPolicyTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, getPolicyTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPolicyTemplate");
            GetPolicyTemplateResponse getPolicyTemplateResponse = (GetPolicyTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPolicyTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPolicyTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPolicyTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPolicyTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$getPolicyTemplate$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSchemaResponse getSchema(GetSchemaRequest getSchemaRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, getSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSchema");
            GetSchemaResponse getSchemaResponse = (GetSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$getSchema$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IsAuthorizedResponse isAuthorized(IsAuthorizedRequest isAuthorizedRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IsAuthorizedResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, isAuthorizedRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IsAuthorized");
            IsAuthorizedResponse isAuthorizedResponse = (IsAuthorizedResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IsAuthorized").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)isAuthorizedRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new IsAuthorizedRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return isAuthorizedResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$isAuthorized$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IsAuthorizedWithTokenResponse isAuthorizedWithToken(IsAuthorizedWithTokenRequest isAuthorizedWithTokenRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IsAuthorizedWithTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, isAuthorizedWithTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IsAuthorizedWithToken");
            IsAuthorizedWithTokenResponse isAuthorizedWithTokenResponse = (IsAuthorizedWithTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IsAuthorizedWithToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)isAuthorizedWithTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new IsAuthorizedWithTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return isAuthorizedWithTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$isAuthorizedWithToken$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentitySourcesResponse listIdentitySources(ListIdentitySourcesRequest listIdentitySourcesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentitySourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, listIdentitySourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentitySources");
            ListIdentitySourcesResponse listIdentitySourcesResponse = (ListIdentitySourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentitySources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentitySourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentitySourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIdentitySourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$listIdentitySources$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListIdentitySourcesIterable listIdentitySourcesPaginator(ListIdentitySourcesRequest listIdentitySourcesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        return new ListIdentitySourcesIterable(this, this.applyPaginatorUserAgent(listIdentitySourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPoliciesResponse listPolicies(ListPoliciesRequest listPoliciesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, listPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPolicies");
            ListPoliciesResponse listPoliciesResponse = (ListPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$listPolicies$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPoliciesIterable listPoliciesPaginator(ListPoliciesRequest listPoliciesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        return new ListPoliciesIterable(this, this.applyPaginatorUserAgent(listPoliciesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPolicyStoresResponse listPolicyStores(ListPolicyStoresRequest listPolicyStoresRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPolicyStoresResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, listPolicyStoresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPolicyStores");
            ListPolicyStoresResponse listPolicyStoresResponse = (ListPolicyStoresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPolicyStores").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPolicyStoresRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPolicyStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPolicyStoresResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$listPolicyStores$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPolicyStoresIterable listPolicyStoresPaginator(ListPolicyStoresRequest listPolicyStoresRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        return new ListPolicyStoresIterable(this, this.applyPaginatorUserAgent(listPolicyStoresRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPolicyTemplatesResponse listPolicyTemplates(ListPolicyTemplatesRequest listPolicyTemplatesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPolicyTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, listPolicyTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPolicyTemplates");
            ListPolicyTemplatesResponse listPolicyTemplatesResponse = (ListPolicyTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPolicyTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPolicyTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPolicyTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPolicyTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$listPolicyTemplates$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPolicyTemplatesIterable listPolicyTemplatesPaginator(ListPolicyTemplatesRequest listPolicyTemplatesRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        return new ListPolicyTemplatesIterable(this, this.applyPaginatorUserAgent(listPolicyTemplatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutSchemaResponse putSchema(PutSchemaRequest putSchemaRequest) throws ValidationException, ServiceQuotaExceededException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, putSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSchema");
            PutSchemaResponse putSchemaResponse = (PutSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$putSchema$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIdentitySourceResponse updateIdentitySource(UpdateIdentitySourceRequest updateIdentitySourceRequest) throws ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIdentitySourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, updateIdentitySourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIdentitySource");
            UpdateIdentitySourceResponse updateIdentitySourceResponse = (UpdateIdentitySourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIdentitySource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIdentitySourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateIdentitySourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateIdentitySourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$updateIdentitySource$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePolicyResponse updatePolicy(UpdatePolicyRequest updatePolicyRequest) throws ValidationException, ServiceQuotaExceededException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, updatePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePolicy");
            UpdatePolicyResponse updatePolicyResponse = (UpdatePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$updatePolicy$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePolicyStoreResponse updatePolicyStore(UpdatePolicyStoreRequest updatePolicyStoreRequest) throws ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePolicyStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, updatePolicyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePolicyStore");
            UpdatePolicyStoreResponse updatePolicyStoreResponse = (UpdatePolicyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePolicyStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePolicyStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePolicyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePolicyStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$updatePolicyStore$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePolicyTemplateResponse updatePolicyTemplate(UpdatePolicyTemplateRequest updatePolicyTemplateRequest) throws ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, VerifiedPermissionsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePolicyTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultVerifiedPermissionsClient.resolveMetricPublishers(this.clientConfiguration, updatePolicyTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"VerifiedPermissions");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePolicyTemplate");
            UpdatePolicyTemplateResponse updatePolicyTemplateResponse = (UpdatePolicyTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePolicyTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePolicyTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePolicyTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePolicyTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultVerifiedPermissionsClient.lambda$updatePolicyTemplate$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends VerifiedPermissionsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.89").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((VerifiedPermissionsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "verifiedpermissions";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(VerifiedPermissionsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final VerifiedPermissionsServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updatePolicyTemplate$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePolicyStore$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePolicy$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateIdentitySource$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putSchema$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPolicyTemplates$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPolicyStores$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPolicies$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentitySources$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$isAuthorizedWithToken$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$isAuthorized$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSchema$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPolicyTemplate$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPolicyStore$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPolicy$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentitySource$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePolicyTemplate$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePolicyStore$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePolicy$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIdentitySource$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPolicyTemplate$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPolicyStore$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPolicy$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIdentitySource$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

