/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class ConstructorToFluent
extends Recipe {
    private final String clzzFqcn;
    private final List<String> parameterTypes;
    private final List<String> fluentNames;

    @JsonCreator
    public ConstructorToFluent(@JsonProperty(value="clzzFqcn") String clzzFqcn, @JsonProperty(value="parameterTypes") List<String> parameterTypes, @JsonProperty(value="fluentNames") List<String> fluentNames) {
        this.clzzFqcn = clzzFqcn;
        this.parameterTypes = parameterTypes;
        this.fluentNames = fluentNames;
        if (fluentNames.size() != parameterTypes.size()) {
            throw new IllegalArgumentException("parameterTypes and fluentNames must be the same length.");
        }
    }

    public String getDisplayName() {
        return "Moves constructor arguments to fluent setters";
    }

    public String getDescription() {
        return "A recipe that takes constructor arguments and moves them to the specified fluent setters on the object.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        List<JavaType> paramJavaTypes = this.parameterTypes.stream().map(JavaType::buildType).collect(Collectors.toList());
        return new Visitor(this.clzzFqcn, paramJavaTypes, this.fluentNames);
    }

    private static class Visitor
    extends JavaVisitor<ExecutionContext> {
        private final JavaType.FullyQualified clzz;
        private final List<JavaType> parameterTypes;
        private final List<String> fluentNames;

        Visitor(String clzz, List<JavaType> parameterTypes, List<String> fluentNames) {
            this.clzz = SdkTypeUtils.fullyQualified(clzz);
            this.parameterTypes = parameterTypes;
            this.fluentNames = fluentNames;
        }

        public J visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
            JavaType.Method ctorType = newClass.getMethodType();
            if (ctorType == null) {
                return newClass;
            }
            if (!this.clzz.isAssignableFrom((JavaType)ctorType.getDeclaringType())) {
                return newClass;
            }
            List paramTypes = ctorType.getParameterTypes();
            if (paramTypes.size() != this.parameterTypes.size()) {
                return newClass;
            }
            for (int i = 0; i < this.parameterTypes.size(); ++i) {
                JavaType expected = this.parameterTypes.get(i);
                if (TypeUtils.isAssignableTo((JavaType)expected, (JavaType)((JavaType)paramTypes.get(i)))) continue;
                return newClass;
            }
            List arguments = newClass.getArguments();
            ctorType = ctorType.withParameterTypes(Collections.emptyList()).withParameterNames(Collections.emptyList());
            newClass = newClass.withArguments(Collections.emptyList()).withMethodType(ctorType);
            JavaType.FullyQualified declaringType = ctorType.getDeclaringType();
            J.NewClass select = newClass;
            for (int i = 0; i < this.parameterTypes.size(); ++i) {
                JavaType paramType = this.parameterTypes.get(i);
                String name = this.fluentNames.get(i);
                Expression argExpr = (Expression)((Expression)arguments.get(i)).withPrefix(Space.EMPTY);
                select = Visitor.addWither((Expression)select, name, paramType, argExpr, declaringType);
            }
            return select;
        }

        private static J.MethodInvocation addWither(Expression select, String simpleName, JavaType parameterType, Expression paramExpr, JavaType.FullyQualified declaringType) {
            JavaType.Method methodType = new JavaType.Method(null, 0L, declaringType, simpleName, (JavaType)declaringType, Collections.singletonList(simpleName), Collections.singletonList(parameterType), null, null, null, null);
            J.Identifier witherId = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), simpleName, (JavaType)methodType, null);
            return new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)select), null, witherId, JContainer.build(Collections.singletonList(JRightPadded.build((Object)paramExpr))), methodType);
        }
    }
}

