/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class SdkBytesToByteBuffer
extends Recipe {
    private static final Pattern BYTE_BUFFER_PATTERN = Pattern.compile(ByteBuffer.class.getCanonicalName());

    @NlsRewrite.DisplayName
    public String getDisplayName() {
        return "Convert SdkBytes to ByteBuffer";
    }

    @NlsRewrite.Description
    public String getDescription() {
        return "Convert SdkBytes to ByteBuffer by calling SdkBytes#asByteBuffer()";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SdkBytesToBufferVisitor();
    }

    private static boolean isV2ModelGetterReturningByteBuffer(J.MethodInvocation method) {
        JavaType.Method mt = method.getMethodType();
        if (mt != null) {
            JavaType.FullyQualified declaringType = mt.getDeclaringType();
            boolean isByteBuffer = mt.getReturnType().isAssignableFrom(BYTE_BUFFER_PATTERN);
            if (SdkTypeUtils.isV2ModelClass((JavaType)declaringType) && isByteBuffer) {
                return true;
            }
        }
        return false;
    }

    private static final class SdkBytesToBufferVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private SdkBytesToBufferVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation originalMethod, ExecutionContext executionContext) {
            J.MethodInvocation method = super.visitMethodInvocation(originalMethod, (Object)executionContext);
            if (!SdkBytesToByteBuffer.isV2ModelGetterReturningByteBuffer(method)) {
                return method;
            }
            String methodName = method.getSimpleName();
            JavaTemplate template = JavaTemplate.builder((String)(method.getSelect() + "." + methodName + "().asByteBuffer()")).contextSensitive().build();
            method = (J.MethodInvocation)template.apply(this.updateCursor((Tree)method), method.getCoordinates().replace(), new Object[0]);
            return method;
        }
    }
}

