/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration.internal.utils;

import org.openrewrite.Cursor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

@SdkInternalApi
public final class NamingUtils {
    private NamingUtils() {
    }

    public static String removeWith(String name) {
        return NamingUtils.removePrefix(name, "with");
    }

    public static String removeSet(String name) {
        return NamingUtils.removePrefix(name, "set");
    }

    public static String removeGet(String name) {
        return NamingUtils.removePrefix(name, "get");
    }

    private static String removePrefix(String name, String prefix) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        if (!name.startsWith(prefix)) {
            return name;
        }
        name = StringUtils.replaceOnce((String)name, (String)prefix, (String)"");
        return StringUtils.uncapitalize((String)CodegenNamingUtils.pascalCase((String)name));
    }

    public static boolean isWither(String name) {
        return !StringUtils.isBlank((CharSequence)name) && name.startsWith("with");
    }

    public static boolean isSetter(String name) {
        return !StringUtils.isBlank((CharSequence)name) && name.startsWith("set");
    }

    public static boolean isGetter(String name) {
        return !StringUtils.isBlank((CharSequence)name) && name.startsWith("get") && !"get".equals(name);
    }

    public static J.MethodInvocation transformMethodName(J.MethodInvocation method, String newMethodName, Cursor cursor) {
        return (J.MethodInvocation)JavaTemplate.builder((String)("#{any()}." + newMethodName)).build().apply(cursor, method.getCoordinates().replace(), new Object[]{method.getSelect()});
    }
}

