/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.IdentifierUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class V1BuilderVariationsToV2Builder
extends Recipe {
    public String getDisplayName() {
        return "V1 client builder variations to builder()";
    }

    public String getDescription() {
        return "Transforms V1 builder variations to builder()";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            method = super.visitMethodInvocation(method, (Object)executionContext);
            JavaType selectType = null;
            Expression select = method.getSelect();
            if (select != null) {
                selectType = select.getType();
            }
            if (selectType == null || !Visitor.shouldChangeMethod(selectType)) {
                return method;
            }
            if (SdkTypeUtils.isV2AsyncClientClass(selectType)) {
                return this.renameAsyncBuilderToBuilder(method, selectType);
            }
            if (SdkTypeUtils.isV2ClientBuilder(selectType) || SdkTypeUtils.isV2TransferManager(selectType)) {
                return this.renameStandardToBuilderOrDefaultClientToCreate(method, selectType);
            }
            return method;
        }

        private static boolean shouldChangeMethod(JavaType selectType) {
            return SdkTypeUtils.isV2ClientBuilder(selectType) || SdkTypeUtils.isV2AsyncClientClass(selectType) || SdkTypeUtils.isV2TransferManager(selectType);
        }

        private J.MethodInvocation renameStandardToBuilderOrDefaultClientToCreate(J.MethodInvocation method, JavaType selectType) {
            JavaType.FullyQualified returnType;
            String methodName = method.getSimpleName();
            JavaType.Method mt = method.getMethodType();
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)selectType);
            if (mt == null || fullyQualified == null) {
                return method;
            }
            JavaType.FullyQualified v2Client = SdkTypeUtils.v2ClientFromClientBuilder(fullyQualified);
            if ("standard".equals(methodName)) {
                methodName = "builder";
                returnType = fullyQualified;
            } else if ("defaultClient".equals(methodName) || "defaultTransferManager".equals(methodName)) {
                methodName = "create";
                returnType = v2Client;
            } else {
                return method;
            }
            J.Identifier id = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), v2Client.getClassName(), (JavaType)v2Client, null);
            JavaType.Method methodType = new JavaType.Method(null, 0L, v2Client, methodName, (JavaType)returnType, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            J.Identifier builderOrCreateMethod = IdentifierUtils.makeId(methodName, (JavaType)methodType);
            J.MethodInvocation builderInvoke = new J.MethodInvocation(Tree.randomId(), method.getPrefix(), Markers.EMPTY, JRightPadded.build((Object)id), null, builderOrCreateMethod, JContainer.empty(), methodType);
            this.maybeRemoveImport(fullyQualified);
            this.maybeAddImport(v2Client);
            return builderInvoke;
        }

        private J.MethodInvocation renameAsyncBuilderToBuilder(J.MethodInvocation method, JavaType selectType) {
            String methodName = method.getSimpleName();
            JavaType.Method mt = method.getMethodType();
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)selectType);
            if (mt == null || fullyQualified == null) {
                return method;
            }
            if ("asyncBuilder".equals(methodName)) {
                methodName = "builder";
                mt = mt.withName(methodName);
                method = method.withName(method.getName().withSimpleName(methodName).withType((JavaType)mt)).withMethodType(mt);
            }
            return method;
        }
    }
}

