/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class EnumCasingToV2
extends Recipe {
    private static Set<String> ENUMS = new HashSet<String>();

    public String getDisplayName() {
        return "V1 Enum Casing to V2";
    }

    public String getDescription() {
        return "Transforms V1 enum constants from pascal case to screaming snake case for v2.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static String v2Casing(String enumValue) {
        String result = enumValue;
        result = result.replaceAll("textORcsv", "TEXT_OR_CSV");
        result = String.join((CharSequence)"_", CodegenNamingUtils.splitOnWordBoundaries((String)result));
        return StringUtils.upperCase((String)result);
    }

    private static class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            J.FieldAccess fa = super.visitFieldAccess(fieldAccess, (Object)ctx);
            if (this.isV2EnumValue(fa)) {
                String v2Casing = EnumCasingToV2.v2Casing(fa.getSimpleName());
                ENUMS.add(v2Casing);
                return fa.withName(fa.getName().withSimpleName(v2Casing));
            }
            return fa;
        }

        public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
            J.Identifier id = super.visitIdentifier(identifier, (Object)ctx);
            if (ENUMS.contains(id.getSimpleName())) {
                JavaType.Variable fieldType = id.getFieldType();
                if (fieldType == null) {
                    return id;
                }
                JavaType.Variable variable = fieldType.withName(id.getSimpleName());
                return id.withFieldType(variable);
            }
            return id;
        }

        public boolean isV2EnumValue(J.FieldAccess fa) {
            JavaType javaType = fa.getTarget().getType();
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)javaType);
            if (fullyQualified != null) {
                return SdkTypeUtils.isV2ModelClass(javaType) && fullyQualified.getKind() == JavaType.FullyQualified.Kind.Enum;
            }
            return false;
        }
    }
}

