/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public class S3NonStreamingRequestToV2Complex
extends Recipe {
    private static final String V2_S3_PKG = "software.amazon.awssdk.services.s3";
    private static final MethodMatcher DISABLE_REQUESTER_PAYS = S3NonStreamingRequestToV2Complex.createMethodMatcher("disableRequesterPays(String)");
    private static final MethodMatcher ENABLE_REQUESTER_PAYS = S3NonStreamingRequestToV2Complex.createMethodMatcher("enableRequesterPays(String)");
    private static final MethodMatcher IS_REQUESTER_PAYS_ENABLED = S3NonStreamingRequestToV2Complex.createMethodMatcher("isRequesterPaysEnabled(String)");
    private static final MethodMatcher GET_OBJECT_AS_STRING = S3NonStreamingRequestToV2Complex.createMethodMatcher("getObjectAsString(String, String)");
    private static final MethodMatcher GET_URL = S3NonStreamingRequestToV2Complex.createMethodMatcher("getUrl(String, String)");
    private static final MethodMatcher LIST_BUCKETS = S3NonStreamingRequestToV2Complex.createMethodMatcher("listBuckets()");
    private static final MethodMatcher RESTORE_OBJECT = S3NonStreamingRequestToV2Complex.createMethodMatcher("restoreObject(String, String, int)");
    private static final MethodMatcher SET_OBJECT_REDIRECT_LOCATION = S3NonStreamingRequestToV2Complex.createMethodMatcher("objectRedirectLocation(String, String, String)");
    private static final MethodMatcher CHANGE_OBJECT_STORAGE_CLASS = S3NonStreamingRequestToV2Complex.createMethodMatcher(String.format("changeObjectStorageClass(String, String, %s.model.StorageClass)", "software.amazon.awssdk.services.s3"));
    private static final MethodMatcher CREATE_BUCKET = S3NonStreamingRequestToV2Complex.createMethodMatcher("createBucket(String, String)");

    private static MethodMatcher createMethodMatcher(String methodSignature) {
        return new MethodMatcher("software.amazon.awssdk.services.s3.S3Client " + methodSignature, true);
    }

    public String getDisplayName() {
        return "V1 S3 non-streaming requests to V2";
    }

    public String getDescription() {
        return "Transform usage of V1 S3 non-streaming requests to V2.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (this.isCompleteMpuRequestMultipartUploadSetter(method)) {
                method = this.transformCompleteMpuRequestCompletedPartsArg(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (DISABLE_REQUESTER_PAYS.matches(method, false)) {
                method = this.transformSetRequesterPays(method, false);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (ENABLE_REQUESTER_PAYS.matches(method, false)) {
                method = this.transformSetRequesterPays(method, true);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (IS_REQUESTER_PAYS_ENABLED.matches(method, false)) {
                method = this.transformIsRequesterPays(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (GET_OBJECT_AS_STRING.matches(method, false)) {
                method = this.transformGetObjectAsString(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (GET_URL.matches(method, false)) {
                method = this.transformGetUrl(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (LIST_BUCKETS.matches(method, false)) {
                method = this.transformListBuckets(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (RESTORE_OBJECT.matches(method, false)) {
                method = this.transformRestoreObject(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (SET_OBJECT_REDIRECT_LOCATION.matches(method, false)) {
                method = this.transformSetObjectRedirectLocation(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (CHANGE_OBJECT_STORAGE_CLASS.matches(method, false)) {
                method = this.transformChangeObjectStorageClass(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (CREATE_BUCKET.matches(method, false)) {
                method = this.transformCreateBucket(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            return super.visitMethodInvocation(method, (Object)executionContext);
        }

        private boolean isCompleteMpuRequestMultipartUploadSetter(J.MethodInvocation method) {
            JavaType.FullyQualified completeMpuRequest = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)"software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest.Builder"));
            return "multipartUpload".equals(method.getSimpleName()) && TypeUtils.isAssignableTo((JavaType)completeMpuRequest, (JavaType)method.getSelect().getType());
        }

        private J.MethodInvocation transformCompleteMpuRequestCompletedPartsArg(J.MethodInvocation method) {
            this.addImport("CompletedMultipartUpload");
            String v2Method = "CompletedMultipartUpload.builder().parts(#{any()}).build()";
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0)});
        }

        private J.MethodInvocation transformCreateBucket(J.MethodInvocation method) {
            String v2Method = "#{any()}.createBucket(CreateBucketRequest.builder().bucket(#{any()}).createBucketConfiguration(CreateBucketConfiguration.builder().locationConstraint(#{any()}).build()).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1)});
            this.addImport("CreateBucketRequest");
            this.addImport("CreateBucketConfiguration");
            return method;
        }

        private J.MethodInvocation transformChangeObjectStorageClass(J.MethodInvocation method) {
            String v2Method = "#{any()}.copyObject(CopyObjectRequest.builder().sourceBucket(#{any()}).sourceKey(#{any()}).destinationBucket(#{any()}).destinationKey(#{any()}).storageClass(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addImport("CopyObjectRequest");
            return method;
        }

        private J.MethodInvocation transformSetObjectRedirectLocation(J.MethodInvocation method) {
            String v2Method = "#{any()}.copyObject(CopyObjectRequest.builder().sourceBucket(#{any()}).sourceKey(#{any()}).destinationBucket(#{any()}).destinationKey(#{any()}).websiteRedirectLocation(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addImport("CopyObjectRequest");
            return method;
        }

        private J.MethodInvocation transformRestoreObject(J.MethodInvocation method) {
            String v2Method = "#{any()}.restoreObject(RestoreObjectRequest.builder().bucket(#{any()}).key(#{any()}).restoreRequest(RestoreRequest.builder().days(#{any()}).build()).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addImport("RestoreObjectRequest");
            this.addImport("RestoreRequest");
            return method;
        }

        private J.MethodInvocation transformListBuckets(J.MethodInvocation method) {
            String v2Method = "#{any()}.listBuckets().buckets()";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect()});
            return method;
        }

        private J.MethodInvocation transformGetObjectAsString(J.MethodInvocation method) {
            String v2Method = "#{any()}.getObjectAsBytes(GetObjectRequest.builder().bucket(#{any()}).key(#{any()}).build()).asUtf8String()";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1)});
            this.addImport("GetObjectRequest");
            return method;
        }

        private J.MethodInvocation transformGetUrl(J.MethodInvocation method) {
            String v2Method = "#{any()}.utilities().getUrl(GetUrlRequest.builder().bucket(#{any()}).key(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1)});
            this.addImport("GetUrlRequest");
            return method;
        }

        private J.MethodInvocation transformIsRequesterPays(J.MethodInvocation method) {
            String v2Method = "#{any()}.getBucketRequestPayment(GetBucketRequestPaymentRequest.builder().bucket(#{any()}).build()).payer().toString().equals(\"Requester\")";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0)});
            this.addImport("GetBucketRequestPaymentRequest");
            return method;
        }

        private J.MethodInvocation transformSetRequesterPays(J.MethodInvocation method, boolean enable) {
            String payer = enable ? "REQUESTER" : "BUCKET_OWNER";
            String v2Method = String.format("#{any()}.putBucketRequestPayment(PutBucketRequestPaymentRequest.builder().bucket(#{any()}).requestPaymentConfiguration(RequestPaymentConfiguration.builder().payer(Payer.%s).build()).build())", payer);
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0)});
            this.addImport("PutBucketRequestPaymentRequest");
            this.addImport("RequestPaymentConfiguration");
            this.addImport("Payer");
            return method;
        }

        private void addImport(String pojoName) {
            String fqcn = "software.amazon.awssdk.services.s3.model." + pojoName;
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }
    }
}

