/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.IdentifierUtils;

@SdkInternalApi
public class S3NonStreamingRequestToV2
extends Recipe {
    private static final MethodMatcher DELETE_VERSION = new MethodMatcher("com.amazonaws.services.s3.AmazonS3 deleteVersion(String, String, String)", true);
    private static final MethodMatcher COPY_OBJECT = new MethodMatcher("com.amazonaws.services.s3.AmazonS3 copyObject(String, String, String, String)", true);
    private static final MethodMatcher LIST_VERSIONS = new MethodMatcher("com.amazonaws.services.s3.AmazonS3 listVersions(String, String, String, String, String, Integer)", true);
    private static final MethodMatcher SET_BUCKET_POLICY = new MethodMatcher("com.amazonaws.services.s3.AmazonS3 setBucketPolicy(String, String)", true);
    private static final Map<MethodMatcher, JavaType.FullyQualified> BUCKET_ARG_METHODS = new HashMap<MethodMatcher, JavaType.FullyQualified>();
    private static final Map<MethodMatcher, JavaType.FullyQualified> BUCKET_KEY_ARGS_METHODS = new HashMap<MethodMatcher, JavaType.FullyQualified>();
    private static final Map<MethodMatcher, JavaType.FullyQualified> BUCKET_ID_ARGS_METHODS = new HashMap<MethodMatcher, JavaType.FullyQualified>();
    private static final Map<MethodMatcher, JavaType.FullyQualified> BUCKET_PREFIX_ARGS_METHODS = new HashMap<MethodMatcher, JavaType.FullyQualified>();

    private static MethodMatcher singleStringArgMethod(String method) {
        String signature = "com.amazonaws.services.s3.AmazonS3 " + method + "(java.lang.String)";
        return new MethodMatcher(signature, true);
    }

    private static MethodMatcher twoStringArgsMethod(String method) {
        String signature = "com.amazonaws.services.s3.AmazonS3 " + method + "(java.lang.String, java.lang.String)";
        return new MethodMatcher(signature, true);
    }

    private static JavaType.FullyQualified fcqn(String method) {
        String methodFirstLetterCaps = method.substring(0, 1).toUpperCase(Locale.ROOT) + method.substring(1);
        String typeName = "com.amazonaws.services.s3.model." + methodFirstLetterCaps + "Request";
        return TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)typeName));
    }

    public String getDisplayName() {
        return "V1 S3 non-streaming requests to V2";
    }

    public String getDescription() {
        return "Transform usage of V1 S3 non-streaming requests to V2.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    static {
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("createBucket"), S3NonStreamingRequestToV2.fcqn("createBucket"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("deleteBucket"), S3NonStreamingRequestToV2.fcqn("deleteBucket"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("listObjects"), S3NonStreamingRequestToV2.fcqn("listObjects"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("listObjectsV2"), S3NonStreamingRequestToV2.fcqn("listObjectsV2"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketCrossOriginConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketCrossOriginConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("deleteBucketCrossOriginConfiguration"), S3NonStreamingRequestToV2.fcqn("deleteBucketCrossOriginConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketVersioningConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketVersioningConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("deleteBucketEncryption"), S3NonStreamingRequestToV2.fcqn("deleteBucketEncryption"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("deleteBucketPolicy"), S3NonStreamingRequestToV2.fcqn("deleteBucketPolicy"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketAccelerateConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketAccelerateConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketAcl"), S3NonStreamingRequestToV2.fcqn("getBucketAcl"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketEncryption"), S3NonStreamingRequestToV2.fcqn("getBucketEncryption"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketLifecycleConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketLifecycleConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketNotificationConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketNotificationConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketPolicy"), S3NonStreamingRequestToV2.fcqn("getBucketPolicy"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketLocation"), S3NonStreamingRequestToV2.fcqn("getBucketLocation"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("deleteBucketLifecycleConfiguration"), S3NonStreamingRequestToV2.fcqn("deleteBucketLifecycleConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("deleteBucketReplicationConfiguration"), S3NonStreamingRequestToV2.fcqn("deleteBucketReplicationConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("deleteBucketTaggingConfiguration"), S3NonStreamingRequestToV2.fcqn("deleteBucketTaggingConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("deleteBucketWebsiteConfiguration"), S3NonStreamingRequestToV2.fcqn("deleteBucketWebsiteConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketLoggingConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketLoggingConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketReplicationConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketReplicationConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketTaggingConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketTaggingConfiguration"));
        BUCKET_ARG_METHODS.put(S3NonStreamingRequestToV2.singleStringArgMethod("getBucketWebsiteConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketWebsiteConfiguration"));
        BUCKET_KEY_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("deleteObject"), S3NonStreamingRequestToV2.fcqn("deleteObject"));
        BUCKET_KEY_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("getObject"), S3NonStreamingRequestToV2.fcqn("getObject"));
        BUCKET_KEY_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("getObjectAcl"), S3NonStreamingRequestToV2.fcqn("getObjectAcl"));
        BUCKET_KEY_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("getObjectMetadata"), S3NonStreamingRequestToV2.fcqn("getObjectMetadata"));
        BUCKET_ID_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("deleteBucketAnalyticsConfiguration"), S3NonStreamingRequestToV2.fcqn("deleteBucketAnalyticsConfiguration"));
        BUCKET_ID_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("deleteBucketIntelligentTieringConfiguration"), S3NonStreamingRequestToV2.fcqn("deleteBucketIntelligentTieringConfiguration"));
        BUCKET_ID_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("deleteBucketInventoryConfiguration"), S3NonStreamingRequestToV2.fcqn("deleteBucketInventoryConfiguration"));
        BUCKET_ID_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("deleteBucketMetricsConfiguration"), S3NonStreamingRequestToV2.fcqn("deleteBucketMetricsConfiguration"));
        BUCKET_ID_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("getBucketAnalyticsConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketAnalyticsConfiguration"));
        BUCKET_ID_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("getBucketIntelligentTieringConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketIntelligentTieringConfiguration"));
        BUCKET_ID_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("getBucketInventoryConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketInventoryConfiguration"));
        BUCKET_ID_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("getBucketMetricsConfiguration"), S3NonStreamingRequestToV2.fcqn("getBucketMetricsConfiguration"));
        BUCKET_PREFIX_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("listObjects"), S3NonStreamingRequestToV2.fcqn("listObjects"));
        BUCKET_PREFIX_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("listObjectsV2"), S3NonStreamingRequestToV2.fcqn("listObjectsV2"));
        BUCKET_PREFIX_ARGS_METHODS.put(S3NonStreamingRequestToV2.twoStringArgsMethod("listVersions"), S3NonStreamingRequestToV2.fcqn("listVersions"));
    }

    private static final class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (DELETE_VERSION.matches((MethodCall)method)) {
                method = this.transformMethod(method, S3NonStreamingRequestToV2.fcqn("deleteObject"), "bucket", "key", "versionId");
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (COPY_OBJECT.matches((MethodCall)method)) {
                method = this.transformMethod(method, S3NonStreamingRequestToV2.fcqn("copyObject"), "sourceBucket", "sourceKey", "destinationBucket", "destinationKey");
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (LIST_VERSIONS.matches((MethodCall)method)) {
                method = this.transformMethod(method, S3NonStreamingRequestToV2.fcqn("listVersions"), "bucket", "prefix", "keyMarker", "versionIdMarker", "delimiter", "maxKeys");
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (SET_BUCKET_POLICY.matches((MethodCall)method)) {
                method = this.transformMethod(method, S3NonStreamingRequestToV2.fcqn("putBucketPolicy"), "bucket", "policy");
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            for (Map.Entry entry : BUCKET_ARG_METHODS.entrySet()) {
                if (!((MethodMatcher)entry.getKey()).matches((MethodCall)method)) continue;
                method = this.transformMethod(method, (JavaType.FullyQualified)entry.getValue(), "bucket");
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            for (Map.Entry entry : BUCKET_KEY_ARGS_METHODS.entrySet()) {
                if (!((MethodMatcher)entry.getKey()).matches((MethodCall)method)) continue;
                method = this.transformMethod(method, (JavaType.FullyQualified)entry.getValue(), "bucket", "key");
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            for (Map.Entry entry : BUCKET_ID_ARGS_METHODS.entrySet()) {
                if (!((MethodMatcher)entry.getKey()).matches((MethodCall)method)) continue;
                method = this.transformMethod(method, (JavaType.FullyQualified)entry.getValue(), "bucket", "id");
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            for (Map.Entry entry : BUCKET_PREFIX_ARGS_METHODS.entrySet()) {
                if (!((MethodMatcher)entry.getKey()).matches((MethodCall)method)) continue;
                method = this.transformMethod(method, (JavaType.FullyQualified)entry.getValue(), "bucket", "prefix");
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            return super.visitMethodInvocation(method, (Object)executionContext);
        }

        private J.MethodInvocation transformMethod(J.MethodInvocation method, JavaType.FullyQualified fqcn, String ... args) {
            JavaType.Method methodType = method.getMethodType();
            if (methodType == null) {
                return method;
            }
            List<String> names = Arrays.asList(args);
            ArrayList<JavaType> types = new ArrayList<JavaType>();
            ArrayList<JRightPadded> expressions = new ArrayList<JRightPadded>();
            for (int i = 0; i < names.size(); ++i) {
                Expression expr = (Expression)method.getArguments().get(i);
                types.add(expr.getType());
                expressions.add(JRightPadded.build((Object)expr));
            }
            Expression newPojo = this.argsToPojo(fqcn, names, types, (JContainer<Expression>)JContainer.build(expressions));
            List<Expression> newArgs = Collections.singletonList(newPojo);
            methodType = this.addParamsToMethod(methodType, newArgs);
            return method.withMethodType(methodType).withArguments(newArgs);
        }

        private JavaType.Method addParamsToMethod(JavaType.Method methodType, List<Expression> newArgs) {
            List<String> paramNames = Collections.singletonList("request");
            List paramTypes = newArgs.stream().map(Expression::getType).collect(Collectors.toList());
            return methodType.withParameterTypes(paramTypes).withParameterNames(paramNames);
        }

        private Expression argsToPojo(JavaType.FullyQualified fqcn, List<String> names, List<JavaType> types, JContainer<Expression> args) {
            this.maybeAddImport(fqcn);
            J.Identifier requestId = IdentifierUtils.makeId(fqcn.getClassName(), (JavaType)fqcn);
            JavaType.Method ctorType = new JavaType.Method(null, 0L, fqcn, "<init>", (JavaType)fqcn, names, types, null, null);
            return new J.NewClass(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, Space.EMPTY, (TypeTree)requestId.withPrefix(Space.SINGLE_SPACE), args, null, ctorType);
        }
    }
}

