/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import java.util.Optional;
import java.util.OptionalLong;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.StringUtils;

@SdkProtectedApi
public final class ContentRangeParser {
    private static final Logger log = Logger.loggerFor(ContentRangeParser.class);

    private ContentRangeParser() {
    }

    public static OptionalLong totalBytes(String contentRange) {
        if (StringUtils.isEmpty(contentRange)) {
            return OptionalLong.empty();
        }
        String trimmed = contentRange.trim();
        if (!trimmed.startsWith("bytes")) {
            return OptionalLong.empty();
        }
        int lastSlash = trimmed.lastIndexOf(47);
        if (lastSlash == -1) {
            return OptionalLong.empty();
        }
        String totalBytes = trimmed.substring(lastSlash + 1);
        if ("*".equals(totalBytes)) {
            return OptionalLong.empty();
        }
        try {
            long value = Long.parseLong(totalBytes);
            return value > 0L ? OptionalLong.of(value) : OptionalLong.empty();
        }
        catch (NumberFormatException e) {
            log.warn(() -> "failed to parse content range", e);
            return OptionalLong.empty();
        }
    }

    public static Optional<Pair<Long, Long>> range(String contentRange) {
        if (StringUtils.isEmpty(contentRange)) {
            return Optional.empty();
        }
        String trimmed = contentRange.trim();
        if (!trimmed.startsWith("bytes ")) {
            return Optional.empty();
        }
        String withoutBytes = trimmed.substring("bytes ".length());
        if (withoutBytes.startsWith("*")) {
            return Optional.empty();
        }
        int hyphen = withoutBytes.indexOf(45);
        if (hyphen == -1) {
            return Optional.empty();
        }
        String begin = withoutBytes.substring(0, hyphen);
        int slash = withoutBytes.indexOf(47);
        if (slash == -1) {
            return Optional.empty();
        }
        String end = withoutBytes.substring(hyphen + 1, slash);
        try {
            long startInt = Long.parseLong(begin);
            long endInt = Long.parseLong(end);
            return Optional.of(Pair.of(startInt, endInt));
        }
        catch (Exception e) {
            log.debug(() -> "failed to parse content range", e);
            return Optional.empty();
        }
    }
}

