/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.http;

import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

public final class SdkHttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN = Pattern.compile(Pattern.quote("+") + "|" + Pattern.quote("*") + "|" + Pattern.quote("%7E") + "|" + Pattern.quote("%2F"));

    private SdkHttpUtils() {
    }

    public static String urlEncode(String value) {
        return SdkHttpUtils.urlEncode(value, false);
    }

    public static String urlEncodeIgnoreSlashes(String value) {
        return SdkHttpUtils.urlEncode(value, true);
    }

    public static String formDataEncode(String value) {
        return value == null ? null : FunctionalUtils.invokeSafely(() -> URLEncoder.encode(value, DEFAULT_ENCODING));
    }

    public static Map<String, List<String>> encodeQueryParameters(Map<String, List<String>> rawQueryParameters) {
        return SdkHttpUtils.encodeMapOfLists(rawQueryParameters, SdkHttpUtils::urlEncode);
    }

    public static Map<String, List<String>> encodeFormData(Map<String, List<String>> rawFormData) {
        return SdkHttpUtils.encodeMapOfLists(rawFormData, SdkHttpUtils::formDataEncode);
    }

    private static Map<String, List<String>> encodeMapOfLists(Map<String, List<String>> map, UnaryOperator<String> encoder) {
        Validate.notNull(map, "Map must not be null.", new Object[0]);
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> queryParameter : map.entrySet()) {
            String key = queryParameter.getKey();
            String encodedKey = (String)encoder.apply(key);
            List<String> value = queryParameter.getValue();
            List encodedValue = value == null ? null : queryParameter.getValue().stream().map(encoder).collect(Collectors.toList());
            result.put(encodedKey, encodedValue);
        }
        return result;
    }

    private static String urlEncode(String value, boolean ignoreSlashes) {
        if (value == null) {
            return null;
        }
        String encoded = FunctionalUtils.invokeSafely(() -> URLEncoder.encode(value, DEFAULT_ENCODING));
        Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
        StringBuffer buffer = new StringBuffer(encoded.length());
        while (matcher.find()) {
            String replacement = matcher.group(0);
            if ("+".equals(replacement)) {
                replacement = "%20";
            } else if ("*".equals(replacement)) {
                replacement = "%2A";
            } else if ("%7E".equals(replacement)) {
                replacement = "~";
            } else if (ignoreSlashes && "%2F".equals(replacement)) {
                replacement = "/";
            }
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static Optional<String> encodeAndFlattenQueryParameters(Map<String, List<String>> rawQueryParameters) {
        return SdkHttpUtils.flattenQueryParameters(SdkHttpUtils.encodeQueryParameters(rawQueryParameters));
    }

    public static Optional<String> encodeAndFlattenFormData(Map<String, List<String>> rawFormData) {
        return SdkHttpUtils.flattenQueryParameters(SdkHttpUtils.encodeFormData(rawFormData));
    }

    public static Optional<String> flattenQueryParameters(Map<String, List<String>> toFlatten) {
        if (toFlatten.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, List<String>> encodedQueryParameter : toFlatten.entrySet()) {
            String key = encodedQueryParameter.getKey();
            List values = Optional.ofNullable(encodedQueryParameter.getValue()).orElseGet(Collections::emptyList);
            for (String value : values) {
                if (result.length() > 0) {
                    result.append('&');
                }
                result.append(key);
                if (value == null) continue;
                result.append('=');
                result.append(value);
            }
        }
        return Optional.of(result.toString());
    }

    public static boolean isUsingStandardPort(String protocol, Integer port) {
        Validate.paramNotNull(protocol, "protocol");
        Validate.isTrue(protocol.equals("http") || protocol.equals("https"), "Protocol must be 'http' or 'https', but was '%s'.", protocol);
        String scheme = StringUtils.lowerCase(protocol);
        return port == null || port == -1 || scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443;
    }

    public static int standardPort(String protocol) {
        if (protocol.equalsIgnoreCase("http")) {
            return 80;
        }
        if (protocol.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new IllegalArgumentException("Unknown protocol: " + protocol);
    }

    public static String appendUri(String baseUri, String path) {
        Validate.paramNotNull(baseUri, "baseUri");
        StringBuilder resultUri = new StringBuilder(baseUri);
        if (!StringUtils.isEmpty(path)) {
            if (!baseUri.endsWith("/")) {
                resultUri.append("/");
            }
            resultUri.append(path.startsWith("/") ? path.substring(1) : path);
        }
        return resultUri.toString();
    }

    public static Stream<String> allMatchingHeaders(Map<String, List<String>> headers, String header) {
        return headers.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(header)).flatMap(e -> e.getValue() != null ? ((List)e.getValue()).stream() : Stream.empty());
    }

    public static Optional<String> firstMatchingHeader(Map<String, List<String>> headers, String header) {
        return SdkHttpUtils.allMatchingHeaders(headers, header).findFirst();
    }
}

