/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import java.util.Optional;
import software.amazon.awssdk.utils.SystemSettingUtils;

public interface SystemSetting {
    public String property();

    public String environmentVariable();

    public String defaultValue();

    default public Optional<String> getStringValue() {
        return SystemSettingUtils.resolveSetting(this);
    }

    default public String getStringValueOrThrow() {
        return this.getStringValue().orElseThrow(() -> new IllegalStateException("Either the environment variable " + this.environmentVariable() + " or the javaproperty " + this.property() + " must be set."));
    }

    default public Optional<Boolean> getBooleanValue() {
        return this.getStringValue().map(value -> SystemSettingUtils.safeStringToBoolean(this, value));
    }

    default public Boolean getBooleanValueOrThrow() {
        return this.getBooleanValue().orElseThrow(() -> new IllegalStateException("Either the environment variable " + this.environmentVariable() + " or the javaproperty " + this.property() + " must be set."));
    }
}

