/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import java.util.function.BiFunction;
import software.amazon.awssdk.utils.Validate;

public final class Pair<LeftT, RightT> {
    private final LeftT left;
    private final RightT right;

    public Pair(LeftT left, RightT right) {
        this.left = Validate.paramNotNull(left, "left");
        this.right = Validate.paramNotNull(right, "right");
    }

    public LeftT left() {
        return this.left;
    }

    public RightT right() {
        return this.right;
    }

    public <ReturnT> ReturnT apply(BiFunction<LeftT, RightT, ReturnT> function) {
        return function.apply(this.left, this.right);
    }
}

