/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

public class ExecutorUtils {
    private static Logger LOG = Logger.loggerFor(ExecutorUtils.class);

    private ExecutorUtils() {
    }

    public static ExecutorService newSingleDaemonThreadExecutor(int queueCapacity, String threadNameFormat) {
        return new ThreadPoolExecutor(0, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), new ThreadFactoryBuilder().daemonThreads(true).threadNamePrefix(threadNameFormat).build());
    }

    public static void shutdown(ExecutorService executorService) {
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public static void shutdownAndAwaitTermination(ExecutorService executorService, Duration maxWaitDuration) {
        if (executorService == null) {
            return;
        }
        long halfMaxWaitDurationInMillis = maxWaitDuration.toMillis() / 2L;
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(halfMaxWaitDurationInMillis, TimeUnit.MILLISECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(halfMaxWaitDurationInMillis, TimeUnit.MILLISECONDS)) {
                    LOG.warn(() -> "Executor service did not shut down after " + maxWaitDuration.toMillis() + "ms.");
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn(() -> "Interrupted while waiting for the executor service to shut down.");
        }
    }
}

