/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.urlconnection;

import java.time.Duration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpClientFactory;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UrlConnectionSdkHttpClientFactory
implements SdkHttpClientFactory,
ToCopyableBuilder<Builder, UrlConnectionSdkHttpClientFactory> {
    private final AttributeMap options;

    private UrlConnectionSdkHttpClientFactory(DefaultBuilder builder) {
        this.options = builder.options.build();
    }

    public SdkHttpClient createHttpClientWithDefaults(AttributeMap serviceDefaults) {
        return new UrlConnectionHttpClient(this.options.merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
    }

    public SdkHttpClient createHttpClient() {
        return this.createHttpClientWithDefaults(AttributeMap.empty());
    }

    public static Builder builder() {
        return new DefaultBuilder(AttributeMap.builder());
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this.options.toBuilder());
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder options;

        private DefaultBuilder(AttributeMap.Builder options) {
            this.options = options;
        }

        public UrlConnectionSdkHttpClientFactory build() {
            return new UrlConnectionSdkHttpClientFactory(this);
        }

        @Override
        public Builder socketTimeout(Duration socketTimeout) {
            this.options.put((AttributeMap.Key)SdkHttpConfigurationOption.SOCKET_TIMEOUT, (Object)socketTimeout);
            return this;
        }

        public void setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout(socketTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration connectionTimeout) {
            this.options.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UrlConnectionSdkHttpClientFactory> {
        public Builder socketTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);
    }
}

