/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.urlconnection;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.AbortableCallable;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
final class UrlConnectionHttpClient
implements SdkHttpClient {
    private final AttributeMap options;

    UrlConnectionHttpClient(AttributeMap options) {
        this.options = options;
    }

    public AbortableCallable<SdkHttpFullResponse> prepareRequest(SdkHttpFullRequest request, SdkRequestContext requestContext) {
        HttpURLConnection connection = this.createAndConfigureConnection(request);
        return new RequestCallable(connection, request);
    }

    public <T> Optional<T> getConfigurationValue(SdkHttpConfigurationOption<T> key) {
        return Optional.ofNullable(this.options.get(key));
    }

    public void close() throws Exception {
    }

    private HttpURLConnection createAndConfigureConnection(SdkHttpFullRequest request) {
        HttpURLConnection connection = (HttpURLConnection)FunctionalUtils.invokeSafely(() -> (HttpURLConnection)this.createRequest(request).toURL().openConnection());
        request.getHeaders().forEach((key, values) -> values.forEach(value -> connection.setRequestProperty((String)key, (String)value)));
        FunctionalUtils.invokeSafely(() -> connection.setRequestMethod(request.getHttpMethod().name()));
        if (request.getContent() != null) {
            connection.setDoOutput(true);
        }
        connection.setConnectTimeout(NumericUtils.saturatedCast((long)((Duration)this.options.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).toMillis()));
        connection.setReadTimeout(NumericUtils.saturatedCast((long)((Duration)this.options.get((AttributeMap.Key)SdkHttpConfigurationOption.SOCKET_TIMEOUT)).toMillis()));
        return connection;
    }

    private URI createRequest(SdkHttpFullRequest request) {
        String params;
        StringBuilder uriBuilder = new StringBuilder(request.getEndpoint().toString());
        if (StringUtils.isNotBlank((CharSequence)request.getResourcePath())) {
            uriBuilder.append(request.getResourcePath());
        }
        if (StringUtils.isNotBlank((CharSequence)(params = request.getParameters().entrySet().stream().flatMap(this::flattenParams).collect(Collectors.joining("&"))))) {
            uriBuilder.append("?").append(params);
        }
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(uriBuilder.toString()));
    }

    private Stream<String> flattenParams(Map.Entry<String, List<String>> e) {
        if (e.getValue() == null || e.getValue().size() == 0 || e.getValue().get(0) == null) {
            return Stream.of(UrlConnectionHttpClient.encode(e.getKey()));
        }
        return e.getValue().stream().map(v -> UrlConnectionHttpClient.encode((String)e.getKey()) + "=" + UrlConnectionHttpClient.encode(v));
    }

    private static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    private static String encode(String string) {
        return (String)FunctionalUtils.invokeSafely(() -> URLEncoder.encode(string, StandardCharsets.UTF_8.name()));
    }

    private static class RequestCallable
    implements AbortableCallable<SdkHttpFullResponse> {
        private final HttpURLConnection connection;
        private final SdkHttpFullRequest request;

        private RequestCallable(HttpURLConnection connection, SdkHttpFullRequest request) {
            this.connection = connection;
            this.request = request;
        }

        public SdkHttpFullResponse call() throws Exception {
            this.connection.connect();
            if (this.request.getContent() != null) {
                IoUtils.copy((InputStream)this.request.getContent(), (OutputStream)this.connection.getOutputStream());
            }
            int responseCode = this.connection.getResponseCode();
            return SdkHttpFullResponse.builder().statusCode(responseCode).statusText(this.connection.getResponseMessage()).content(this.connection.getInputStream()).headers(this.extractHeaders(this.connection)).build();
        }

        private Map<String, List<String>> extractHeaders(HttpURLConnection response) {
            return (Map)response.getHeaderFields().entrySet().stream().filter(e -> e.getKey() != null).collect(UrlConnectionHttpClient.toMap());
        }

        public void abort() {
            this.connection.disconnect();
        }
    }
}

