/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.CheckSummary;
import software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse;

public class ListChecksIterable
implements SdkIterable<ListChecksResponse> {
    private final TrustedAdvisorClient client;
    private final ListChecksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChecksIterable(TrustedAdvisorClient client, ListChecksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChecksResponseFetcher();
    }

    public Iterator<ListChecksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CheckSummary> checkSummaries() {
        Function<ListChecksResponse, Iterator> getIterator = response -> {
            if (response != null && response.checkSummaries() != null) {
                return response.checkSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListChecksResponseFetcher
    implements SyncPageFetcher<ListChecksResponse> {
        private ListChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListChecksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChecksResponse nextPage(ListChecksResponse previousPage) {
            if (previousPage == null) {
                return ListChecksIterable.this.client.listChecks(ListChecksIterable.this.firstRequest);
            }
            return ListChecksIterable.this.client.listChecks((ListChecksRequest)((Object)ListChecksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

