/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.trustedadvisor.model.TrustedAdvisorRequest;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleStage;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleStageReasonCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOrganizationRecommendationLifecycleRequest
extends TrustedAdvisorRequest
implements ToCopyableBuilder<Builder, UpdateOrganizationRecommendationLifecycleRequest> {
    private static final SdkField<String> LIFECYCLE_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStage").getter(UpdateOrganizationRecommendationLifecycleRequest.getter(UpdateOrganizationRecommendationLifecycleRequest::lifecycleStageAsString)).setter(UpdateOrganizationRecommendationLifecycleRequest.setter(Builder::lifecycleStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStage").build()}).build();
    private static final SdkField<String> ORGANIZATION_RECOMMENDATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationRecommendationIdentifier").getter(UpdateOrganizationRecommendationLifecycleRequest.getter(UpdateOrganizationRecommendationLifecycleRequest::organizationRecommendationIdentifier)).setter(UpdateOrganizationRecommendationLifecycleRequest.setter(Builder::organizationRecommendationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("organizationRecommendationIdentifier").build()}).build();
    private static final SdkField<String> UPDATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateReason").getter(UpdateOrganizationRecommendationLifecycleRequest.getter(UpdateOrganizationRecommendationLifecycleRequest::updateReason)).setter(UpdateOrganizationRecommendationLifecycleRequest.setter(Builder::updateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReason").build()}).build();
    private static final SdkField<String> UPDATE_REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateReasonCode").getter(UpdateOrganizationRecommendationLifecycleRequest.getter(UpdateOrganizationRecommendationLifecycleRequest::updateReasonCodeAsString)).setter(UpdateOrganizationRecommendationLifecycleRequest.setter(Builder::updateReasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReasonCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_STAGE_FIELD, ORGANIZATION_RECOMMENDATION_IDENTIFIER_FIELD, UPDATE_REASON_FIELD, UPDATE_REASON_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("lifecycleStage", LIFECYCLE_STAGE_FIELD);
            this.put("organizationRecommendationIdentifier", ORGANIZATION_RECOMMENDATION_IDENTIFIER_FIELD);
            this.put("updateReason", UPDATE_REASON_FIELD);
            this.put("updateReasonCode", UPDATE_REASON_CODE_FIELD);
        }
    });
    private final String lifecycleStage;
    private final String organizationRecommendationIdentifier;
    private final String updateReason;
    private final String updateReasonCode;

    private UpdateOrganizationRecommendationLifecycleRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleStage = builder.lifecycleStage;
        this.organizationRecommendationIdentifier = builder.organizationRecommendationIdentifier;
        this.updateReason = builder.updateReason;
        this.updateReasonCode = builder.updateReasonCode;
    }

    public final UpdateRecommendationLifecycleStage lifecycleStage() {
        return UpdateRecommendationLifecycleStage.fromValue(this.lifecycleStage);
    }

    public final String lifecycleStageAsString() {
        return this.lifecycleStage;
    }

    public final String organizationRecommendationIdentifier() {
        return this.organizationRecommendationIdentifier;
    }

    public final String updateReason() {
        return this.updateReason;
    }

    public final UpdateRecommendationLifecycleStageReasonCode updateReasonCode() {
        return UpdateRecommendationLifecycleStageReasonCode.fromValue(this.updateReasonCode);
    }

    public final String updateReasonCodeAsString() {
        return this.updateReasonCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationRecommendationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateReasonCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOrganizationRecommendationLifecycleRequest)) {
            return false;
        }
        UpdateOrganizationRecommendationLifecycleRequest other = (UpdateOrganizationRecommendationLifecycleRequest)((Object)obj);
        return Objects.equals(this.lifecycleStageAsString(), other.lifecycleStageAsString()) && Objects.equals(this.organizationRecommendationIdentifier(), other.organizationRecommendationIdentifier()) && Objects.equals(this.updateReason(), other.updateReason()) && Objects.equals(this.updateReasonCodeAsString(), other.updateReasonCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOrganizationRecommendationLifecycleRequest").add("LifecycleStage", (Object)this.lifecycleStageAsString()).add("OrganizationRecommendationIdentifier", (Object)this.organizationRecommendationIdentifier()).add("UpdateReason", (Object)(this.updateReason() == null ? null : "*** Sensitive Data Redacted ***")).add("UpdateReasonCode", (Object)this.updateReasonCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lifecycleStage": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStageAsString()));
            }
            case "organizationRecommendationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.organizationRecommendationIdentifier()));
            }
            case "updateReason": {
                return Optional.ofNullable(clazz.cast(this.updateReason()));
            }
            case "updateReasonCode": {
                return Optional.ofNullable(clazz.cast(this.updateReasonCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOrganizationRecommendationLifecycleRequest, T> g) {
        return obj -> g.apply((UpdateOrganizationRecommendationLifecycleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TrustedAdvisorRequest.BuilderImpl
    implements Builder {
        private String lifecycleStage;
        private String organizationRecommendationIdentifier;
        private String updateReason;
        private String updateReasonCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOrganizationRecommendationLifecycleRequest model) {
            super(model);
            this.lifecycleStage(model.lifecycleStage);
            this.organizationRecommendationIdentifier(model.organizationRecommendationIdentifier);
            this.updateReason(model.updateReason);
            this.updateReasonCode(model.updateReasonCode);
        }

        public final String getLifecycleStage() {
            return this.lifecycleStage;
        }

        public final void setLifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
        }

        @Override
        public final Builder lifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            return this;
        }

        @Override
        public final Builder lifecycleStage(UpdateRecommendationLifecycleStage lifecycleStage) {
            this.lifecycleStage(lifecycleStage == null ? null : lifecycleStage.toString());
            return this;
        }

        public final String getOrganizationRecommendationIdentifier() {
            return this.organizationRecommendationIdentifier;
        }

        public final void setOrganizationRecommendationIdentifier(String organizationRecommendationIdentifier) {
            this.organizationRecommendationIdentifier = organizationRecommendationIdentifier;
        }

        @Override
        public final Builder organizationRecommendationIdentifier(String organizationRecommendationIdentifier) {
            this.organizationRecommendationIdentifier = organizationRecommendationIdentifier;
            return this;
        }

        public final String getUpdateReason() {
            return this.updateReason;
        }

        public final void setUpdateReason(String updateReason) {
            this.updateReason = updateReason;
        }

        @Override
        public final Builder updateReason(String updateReason) {
            this.updateReason = updateReason;
            return this;
        }

        public final String getUpdateReasonCode() {
            return this.updateReasonCode;
        }

        public final void setUpdateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
        }

        @Override
        public final Builder updateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
            return this;
        }

        @Override
        public final Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode updateReasonCode) {
            this.updateReasonCode(updateReasonCode == null ? null : updateReasonCode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOrganizationRecommendationLifecycleRequest build() {
            return new UpdateOrganizationRecommendationLifecycleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TrustedAdvisorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOrganizationRecommendationLifecycleRequest> {
        public Builder lifecycleStage(String var1);

        public Builder lifecycleStage(UpdateRecommendationLifecycleStage var1);

        public Builder organizationRecommendationIdentifier(String var1);

        public Builder updateReason(String var1);

        public Builder updateReasonCode(String var1);

        public Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

