/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationAwsServiceListCopier;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationLifecycleStage;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationPillar;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationPillarListCopier;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationPillarSpecificAggregates;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationResourcesAggregates;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationSource;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationStatus;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationType;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleStageReasonCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationRecommendation> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(OrganizationRecommendation.getter(OrganizationRecommendation::arn)).setter(OrganizationRecommendation.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> AWS_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("awsServices").getter(OrganizationRecommendation.getter(OrganizationRecommendation::awsServices)).setter(OrganizationRecommendation.setter(Builder::awsServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHECK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkArn").getter(OrganizationRecommendation.getter(OrganizationRecommendation::checkArn)).setter(OrganizationRecommendation.setter(Builder::checkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(OrganizationRecommendation.getter(OrganizationRecommendation::createdAt)).setter(OrganizationRecommendation.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(OrganizationRecommendation.getter(OrganizationRecommendation::createdBy)).setter(OrganizationRecommendation.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(OrganizationRecommendation.getter(OrganizationRecommendation::description)).setter(OrganizationRecommendation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(OrganizationRecommendation.getter(OrganizationRecommendation::id)).setter(OrganizationRecommendation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(OrganizationRecommendation.getter(OrganizationRecommendation::lastUpdatedAt)).setter(OrganizationRecommendation.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> LIFECYCLE_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStage").getter(OrganizationRecommendation.getter(OrganizationRecommendation::lifecycleStageAsString)).setter(OrganizationRecommendation.setter(Builder::lifecycleStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStage").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(OrganizationRecommendation.getter(OrganizationRecommendation::name)).setter(OrganizationRecommendation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RecommendationPillarSpecificAggregates> PILLAR_SPECIFIC_AGGREGATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pillarSpecificAggregates").getter(OrganizationRecommendation.getter(OrganizationRecommendation::pillarSpecificAggregates)).setter(OrganizationRecommendation.setter(Builder::pillarSpecificAggregates)).constructor(RecommendationPillarSpecificAggregates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pillarSpecificAggregates").build()}).build();
    private static final SdkField<List<String>> PILLARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pillars").getter(OrganizationRecommendation.getter(OrganizationRecommendation::pillarsAsStrings)).setter(OrganizationRecommendation.setter(Builder::pillarsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pillars").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> RESOLVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("resolvedAt").getter(OrganizationRecommendation.getter(OrganizationRecommendation::resolvedAt)).setter(OrganizationRecommendation.setter(Builder::resolvedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<RecommendationResourcesAggregates> RESOURCES_AGGREGATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourcesAggregates").getter(OrganizationRecommendation.getter(OrganizationRecommendation::resourcesAggregates)).setter(OrganizationRecommendation.setter(Builder::resourcesAggregates)).constructor(RecommendationResourcesAggregates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesAggregates").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(OrganizationRecommendation.getter(OrganizationRecommendation::sourceAsString)).setter(OrganizationRecommendation.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(OrganizationRecommendation.getter(OrganizationRecommendation::statusAsString)).setter(OrganizationRecommendation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(OrganizationRecommendation.getter(OrganizationRecommendation::typeAsString)).setter(OrganizationRecommendation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> UPDATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateReason").getter(OrganizationRecommendation.getter(OrganizationRecommendation::updateReason)).setter(OrganizationRecommendation.setter(Builder::updateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReason").build()}).build();
    private static final SdkField<String> UPDATE_REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateReasonCode").getter(OrganizationRecommendation.getter(OrganizationRecommendation::updateReasonCodeAsString)).setter(OrganizationRecommendation.setter(Builder::updateReasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReasonCode").build()}).build();
    private static final SdkField<String> UPDATED_ON_BEHALF_OF_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedOnBehalfOf").getter(OrganizationRecommendation.getter(OrganizationRecommendation::updatedOnBehalfOf)).setter(OrganizationRecommendation.setter(Builder::updatedOnBehalfOf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedOnBehalfOf").build()}).build();
    private static final SdkField<String> UPDATED_ON_BEHALF_OF_JOB_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedOnBehalfOfJobTitle").getter(OrganizationRecommendation.getter(OrganizationRecommendation::updatedOnBehalfOfJobTitle)).setter(OrganizationRecommendation.setter(Builder::updatedOnBehalfOfJobTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedOnBehalfOfJobTitle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_SERVICES_FIELD, CHECK_ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, LIFECYCLE_STAGE_FIELD, NAME_FIELD, PILLAR_SPECIFIC_AGGREGATES_FIELD, PILLARS_FIELD, RESOLVED_AT_FIELD, RESOURCES_AGGREGATES_FIELD, SOURCE_FIELD, STATUS_FIELD, TYPE_FIELD, UPDATE_REASON_FIELD, UPDATE_REASON_CODE_FIELD, UPDATED_ON_BEHALF_OF_FIELD, UPDATED_ON_BEHALF_OF_JOB_TITLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("awsServices", AWS_SERVICES_FIELD);
            this.put("checkArn", CHECK_ARN_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("id", ID_FIELD);
            this.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
            this.put("lifecycleStage", LIFECYCLE_STAGE_FIELD);
            this.put("name", NAME_FIELD);
            this.put("pillarSpecificAggregates", PILLAR_SPECIFIC_AGGREGATES_FIELD);
            this.put("pillars", PILLARS_FIELD);
            this.put("resolvedAt", RESOLVED_AT_FIELD);
            this.put("resourcesAggregates", RESOURCES_AGGREGATES_FIELD);
            this.put("source", SOURCE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("updateReason", UPDATE_REASON_FIELD);
            this.put("updateReasonCode", UPDATE_REASON_CODE_FIELD);
            this.put("updatedOnBehalfOf", UPDATED_ON_BEHALF_OF_FIELD);
            this.put("updatedOnBehalfOfJobTitle", UPDATED_ON_BEHALF_OF_JOB_TITLE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<String> awsServices;
    private final String checkArn;
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String id;
    private final Instant lastUpdatedAt;
    private final String lifecycleStage;
    private final String name;
    private final RecommendationPillarSpecificAggregates pillarSpecificAggregates;
    private final List<String> pillars;
    private final Instant resolvedAt;
    private final RecommendationResourcesAggregates resourcesAggregates;
    private final String source;
    private final String status;
    private final String type;
    private final String updateReason;
    private final String updateReasonCode;
    private final String updatedOnBehalfOf;
    private final String updatedOnBehalfOfJobTitle;

    private OrganizationRecommendation(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsServices = builder.awsServices;
        this.checkArn = builder.checkArn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleStage = builder.lifecycleStage;
        this.name = builder.name;
        this.pillarSpecificAggregates = builder.pillarSpecificAggregates;
        this.pillars = builder.pillars;
        this.resolvedAt = builder.resolvedAt;
        this.resourcesAggregates = builder.resourcesAggregates;
        this.source = builder.source;
        this.status = builder.status;
        this.type = builder.type;
        this.updateReason = builder.updateReason;
        this.updateReasonCode = builder.updateReasonCode;
        this.updatedOnBehalfOf = builder.updatedOnBehalfOf;
        this.updatedOnBehalfOfJobTitle = builder.updatedOnBehalfOfJobTitle;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAwsServices() {
        return this.awsServices != null && !(this.awsServices instanceof SdkAutoConstructList);
    }

    public final List<String> awsServices() {
        return this.awsServices;
    }

    public final String checkArn() {
        return this.checkArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final RecommendationLifecycleStage lifecycleStage() {
        return RecommendationLifecycleStage.fromValue(this.lifecycleStage);
    }

    public final String lifecycleStageAsString() {
        return this.lifecycleStage;
    }

    public final String name() {
        return this.name;
    }

    public final RecommendationPillarSpecificAggregates pillarSpecificAggregates() {
        return this.pillarSpecificAggregates;
    }

    public final List<RecommendationPillar> pillars() {
        return RecommendationPillarListCopier.copyStringToEnum(this.pillars);
    }

    public final boolean hasPillars() {
        return this.pillars != null && !(this.pillars instanceof SdkAutoConstructList);
    }

    public final List<String> pillarsAsStrings() {
        return this.pillars;
    }

    public final Instant resolvedAt() {
        return this.resolvedAt;
    }

    public final RecommendationResourcesAggregates resourcesAggregates() {
        return this.resourcesAggregates;
    }

    public final RecommendationSource source() {
        return RecommendationSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final RecommendationStatus status() {
        return RecommendationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final RecommendationType type() {
        return RecommendationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String updateReason() {
        return this.updateReason;
    }

    public final UpdateRecommendationLifecycleStageReasonCode updateReasonCode() {
        return UpdateRecommendationLifecycleStageReasonCode.fromValue(this.updateReasonCode);
    }

    public final String updateReasonCodeAsString() {
        return this.updateReasonCode;
    }

    public final String updatedOnBehalfOf() {
        return this.updatedOnBehalfOf;
    }

    public final String updatedOnBehalfOfJobTitle() {
        return this.updatedOnBehalfOfJobTitle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsServices() ? this.awsServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.checkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarSpecificAggregates());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillars() ? this.pillarsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesAggregates());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateReasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedOnBehalfOf());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedOnBehalfOfJobTitle());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationRecommendation)) {
            return false;
        }
        OrganizationRecommendation other = (OrganizationRecommendation)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasAwsServices() == other.hasAwsServices() && Objects.equals(this.awsServices(), other.awsServices()) && Objects.equals(this.checkArn(), other.checkArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.lifecycleStageAsString(), other.lifecycleStageAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pillarSpecificAggregates(), other.pillarSpecificAggregates()) && this.hasPillars() == other.hasPillars() && Objects.equals(this.pillarsAsStrings(), other.pillarsAsStrings()) && Objects.equals(this.resolvedAt(), other.resolvedAt()) && Objects.equals(this.resourcesAggregates(), other.resourcesAggregates()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.updateReason(), other.updateReason()) && Objects.equals(this.updateReasonCodeAsString(), other.updateReasonCodeAsString()) && Objects.equals(this.updatedOnBehalfOf(), other.updatedOnBehalfOf()) && Objects.equals(this.updatedOnBehalfOfJobTitle(), other.updatedOnBehalfOfJobTitle());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationRecommendation").add("Arn", (Object)this.arn()).add("AwsServices", this.hasAwsServices() ? this.awsServices() : null).add("CheckArn", (Object)this.checkArn()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LifecycleStage", (Object)this.lifecycleStageAsString()).add("Name", (Object)this.name()).add("PillarSpecificAggregates", (Object)this.pillarSpecificAggregates()).add("Pillars", this.hasPillars() ? this.pillarsAsStrings() : null).add("ResolvedAt", (Object)this.resolvedAt()).add("ResourcesAggregates", (Object)this.resourcesAggregates()).add("Source", (Object)this.sourceAsString()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).add("UpdateReason", (Object)(this.updateReason() == null ? null : "*** Sensitive Data Redacted ***")).add("UpdateReasonCode", (Object)this.updateReasonCodeAsString()).add("UpdatedOnBehalfOf", (Object)this.updatedOnBehalfOf()).add("UpdatedOnBehalfOfJobTitle", (Object)this.updatedOnBehalfOfJobTitle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "awsServices": {
                return Optional.ofNullable(clazz.cast(this.awsServices()));
            }
            case "checkArn": {
                return Optional.ofNullable(clazz.cast(this.checkArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "lifecycleStage": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStageAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "pillarSpecificAggregates": {
                return Optional.ofNullable(clazz.cast(this.pillarSpecificAggregates()));
            }
            case "pillars": {
                return Optional.ofNullable(clazz.cast(this.pillarsAsStrings()));
            }
            case "resolvedAt": {
                return Optional.ofNullable(clazz.cast(this.resolvedAt()));
            }
            case "resourcesAggregates": {
                return Optional.ofNullable(clazz.cast(this.resourcesAggregates()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "updateReason": {
                return Optional.ofNullable(clazz.cast(this.updateReason()));
            }
            case "updateReasonCode": {
                return Optional.ofNullable(clazz.cast(this.updateReasonCodeAsString()));
            }
            case "updatedOnBehalfOf": {
                return Optional.ofNullable(clazz.cast(this.updatedOnBehalfOf()));
            }
            case "updatedOnBehalfOfJobTitle": {
                return Optional.ofNullable(clazz.cast(this.updatedOnBehalfOfJobTitle()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationRecommendation, T> g) {
        return obj -> g.apply((OrganizationRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> awsServices = DefaultSdkAutoConstructList.getInstance();
        private String checkArn;
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String id;
        private Instant lastUpdatedAt;
        private String lifecycleStage;
        private String name;
        private RecommendationPillarSpecificAggregates pillarSpecificAggregates;
        private List<String> pillars = DefaultSdkAutoConstructList.getInstance();
        private Instant resolvedAt;
        private RecommendationResourcesAggregates resourcesAggregates;
        private String source;
        private String status;
        private String type;
        private String updateReason;
        private String updateReasonCode;
        private String updatedOnBehalfOf;
        private String updatedOnBehalfOfJobTitle;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationRecommendation model) {
            this.arn(model.arn);
            this.awsServices(model.awsServices);
            this.checkArn(model.checkArn);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.lifecycleStage(model.lifecycleStage);
            this.name(model.name);
            this.pillarSpecificAggregates(model.pillarSpecificAggregates);
            this.pillarsWithStrings(model.pillars);
            this.resolvedAt(model.resolvedAt);
            this.resourcesAggregates(model.resourcesAggregates);
            this.source(model.source);
            this.status(model.status);
            this.type(model.type);
            this.updateReason(model.updateReason);
            this.updateReasonCode(model.updateReasonCode);
            this.updatedOnBehalfOf(model.updatedOnBehalfOf);
            this.updatedOnBehalfOfJobTitle(model.updatedOnBehalfOfJobTitle);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAwsServices() {
            if (this.awsServices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsServices;
        }

        public final void setAwsServices(Collection<String> awsServices) {
            this.awsServices = RecommendationAwsServiceListCopier.copy(awsServices);
        }

        @Override
        public final Builder awsServices(Collection<String> awsServices) {
            this.awsServices = RecommendationAwsServiceListCopier.copy(awsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServices(String ... awsServices) {
            this.awsServices(Arrays.asList(awsServices));
            return this;
        }

        public final String getCheckArn() {
            return this.checkArn;
        }

        public final void setCheckArn(String checkArn) {
            this.checkArn = checkArn;
        }

        @Override
        public final Builder checkArn(String checkArn) {
            this.checkArn = checkArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getLifecycleStage() {
            return this.lifecycleStage;
        }

        public final void setLifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
        }

        @Override
        public final Builder lifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            return this;
        }

        @Override
        public final Builder lifecycleStage(RecommendationLifecycleStage lifecycleStage) {
            this.lifecycleStage(lifecycleStage == null ? null : lifecycleStage.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RecommendationPillarSpecificAggregates.Builder getPillarSpecificAggregates() {
            return this.pillarSpecificAggregates != null ? this.pillarSpecificAggregates.toBuilder() : null;
        }

        public final void setPillarSpecificAggregates(RecommendationPillarSpecificAggregates.BuilderImpl pillarSpecificAggregates) {
            this.pillarSpecificAggregates = pillarSpecificAggregates != null ? pillarSpecificAggregates.build() : null;
        }

        @Override
        public final Builder pillarSpecificAggregates(RecommendationPillarSpecificAggregates pillarSpecificAggregates) {
            this.pillarSpecificAggregates = pillarSpecificAggregates;
            return this;
        }

        public final Collection<String> getPillars() {
            if (this.pillars instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pillars;
        }

        public final void setPillars(Collection<String> pillars) {
            this.pillars = RecommendationPillarListCopier.copy(pillars);
        }

        @Override
        public final Builder pillarsWithStrings(Collection<String> pillars) {
            this.pillars = RecommendationPillarListCopier.copy(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarsWithStrings(String ... pillars) {
            this.pillarsWithStrings(Arrays.asList(pillars));
            return this;
        }

        @Override
        public final Builder pillars(Collection<RecommendationPillar> pillars) {
            this.pillars = RecommendationPillarListCopier.copyEnumToString(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillars(RecommendationPillar ... pillars) {
            this.pillars(Arrays.asList(pillars));
            return this;
        }

        public final Instant getResolvedAt() {
            return this.resolvedAt;
        }

        public final void setResolvedAt(Instant resolvedAt) {
            this.resolvedAt = resolvedAt;
        }

        @Override
        public final Builder resolvedAt(Instant resolvedAt) {
            this.resolvedAt = resolvedAt;
            return this;
        }

        public final RecommendationResourcesAggregates.Builder getResourcesAggregates() {
            return this.resourcesAggregates != null ? this.resourcesAggregates.toBuilder() : null;
        }

        public final void setResourcesAggregates(RecommendationResourcesAggregates.BuilderImpl resourcesAggregates) {
            this.resourcesAggregates = resourcesAggregates != null ? resourcesAggregates.build() : null;
        }

        @Override
        public final Builder resourcesAggregates(RecommendationResourcesAggregates resourcesAggregates) {
            this.resourcesAggregates = resourcesAggregates;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(RecommendationSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecommendationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUpdateReason() {
            return this.updateReason;
        }

        public final void setUpdateReason(String updateReason) {
            this.updateReason = updateReason;
        }

        @Override
        public final Builder updateReason(String updateReason) {
            this.updateReason = updateReason;
            return this;
        }

        public final String getUpdateReasonCode() {
            return this.updateReasonCode;
        }

        public final void setUpdateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
        }

        @Override
        public final Builder updateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
            return this;
        }

        @Override
        public final Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode updateReasonCode) {
            this.updateReasonCode(updateReasonCode == null ? null : updateReasonCode.toString());
            return this;
        }

        public final String getUpdatedOnBehalfOf() {
            return this.updatedOnBehalfOf;
        }

        public final void setUpdatedOnBehalfOf(String updatedOnBehalfOf) {
            this.updatedOnBehalfOf = updatedOnBehalfOf;
        }

        @Override
        public final Builder updatedOnBehalfOf(String updatedOnBehalfOf) {
            this.updatedOnBehalfOf = updatedOnBehalfOf;
            return this;
        }

        public final String getUpdatedOnBehalfOfJobTitle() {
            return this.updatedOnBehalfOfJobTitle;
        }

        public final void setUpdatedOnBehalfOfJobTitle(String updatedOnBehalfOfJobTitle) {
            this.updatedOnBehalfOfJobTitle = updatedOnBehalfOfJobTitle;
        }

        @Override
        public final Builder updatedOnBehalfOfJobTitle(String updatedOnBehalfOfJobTitle) {
            this.updatedOnBehalfOfJobTitle = updatedOnBehalfOfJobTitle;
            return this;
        }

        public OrganizationRecommendation build() {
            return new OrganizationRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationRecommendation> {
        public Builder arn(String var1);

        public Builder awsServices(Collection<String> var1);

        public Builder awsServices(String ... var1);

        public Builder checkArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder lifecycleStage(String var1);

        public Builder lifecycleStage(RecommendationLifecycleStage var1);

        public Builder name(String var1);

        public Builder pillarSpecificAggregates(RecommendationPillarSpecificAggregates var1);

        default public Builder pillarSpecificAggregates(Consumer<RecommendationPillarSpecificAggregates.Builder> pillarSpecificAggregates) {
            return this.pillarSpecificAggregates((RecommendationPillarSpecificAggregates)((RecommendationPillarSpecificAggregates.Builder)RecommendationPillarSpecificAggregates.builder().applyMutation(pillarSpecificAggregates)).build());
        }

        public Builder pillarsWithStrings(Collection<String> var1);

        public Builder pillarsWithStrings(String ... var1);

        public Builder pillars(Collection<RecommendationPillar> var1);

        public Builder pillars(RecommendationPillar ... var1);

        public Builder resolvedAt(Instant var1);

        public Builder resourcesAggregates(RecommendationResourcesAggregates var1);

        default public Builder resourcesAggregates(Consumer<RecommendationResourcesAggregates.Builder> resourcesAggregates) {
            return this.resourcesAggregates((RecommendationResourcesAggregates)((RecommendationResourcesAggregates.Builder)RecommendationResourcesAggregates.builder().applyMutation(resourcesAggregates)).build());
        }

        public Builder source(String var1);

        public Builder source(RecommendationSource var1);

        public Builder status(String var1);

        public Builder status(RecommendationStatus var1);

        public Builder type(String var1);

        public Builder type(RecommendationType var1);

        public Builder updateReason(String var1);

        public Builder updateReasonCode(String var1);

        public Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode var1);

        public Builder updatedOnBehalfOf(String var1);

        public Builder updatedOnBehalfOfJobTitle(String var1);
    }
}

