/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorAsyncClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationResourceSummary;

public class ListRecommendationResourcesPublisher
implements SdkPublisher<ListRecommendationResourcesResponse> {
    private final TrustedAdvisorAsyncClient client;
    private final ListRecommendationResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommendationResourcesPublisher(TrustedAdvisorAsyncClient client, ListRecommendationResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommendationResourcesPublisher(TrustedAdvisorAsyncClient client, ListRecommendationResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommendationResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommendationResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecommendationResourceSummary> recommendationResourceSummaries() {
        Function<ListRecommendationResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendationResourceSummaries() != null) {
                return response.recommendationResourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecommendationResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecommendationResourcesResponseFetcher
    implements AsyncPageFetcher<ListRecommendationResourcesResponse> {
        private ListRecommendationResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommendationResourcesResponse> nextPage(ListRecommendationResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationResourcesPublisher.this.client.listRecommendationResources(ListRecommendationResourcesPublisher.this.firstRequest);
            }
            return ListRecommendationResourcesPublisher.this.client.listRecommendationResources((ListRecommendationResourcesRequest)((Object)ListRecommendationResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

