/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceStatus {
    OK("ok"),
    WARNING("warning"),
    ERROR("error"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceStatus> VALUE_MAP;
    private final String value;

    private ResourceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceStatus> knownValues() {
        EnumSet<ResourceStatus> knownValues = EnumSet.allOf(ResourceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceStatus.class, ResourceStatus::toString);
    }
}

