/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorAsyncClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse;
import software.amazon.awssdk.services.trustedadvisor.model.OrganizationRecommendationResourceSummary;

public class ListOrganizationRecommendationResourcesPublisher
implements SdkPublisher<ListOrganizationRecommendationResourcesResponse> {
    private final TrustedAdvisorAsyncClient client;
    private final ListOrganizationRecommendationResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOrganizationRecommendationResourcesPublisher(TrustedAdvisorAsyncClient client, ListOrganizationRecommendationResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOrganizationRecommendationResourcesPublisher(TrustedAdvisorAsyncClient client, ListOrganizationRecommendationResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOrganizationRecommendationResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOrganizationRecommendationResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrganizationRecommendationResourceSummary> organizationRecommendationResourceSummaries() {
        Function<ListOrganizationRecommendationResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationRecommendationResourceSummaries() != null) {
                return response.organizationRecommendationResourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOrganizationRecommendationResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOrganizationRecommendationResourcesResponseFetcher
    implements AsyncPageFetcher<ListOrganizationRecommendationResourcesResponse> {
        private ListOrganizationRecommendationResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationRecommendationResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOrganizationRecommendationResourcesResponse> nextPage(ListOrganizationRecommendationResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationRecommendationResourcesPublisher.this.client.listOrganizationRecommendationResources(ListOrganizationRecommendationResourcesPublisher.this.firstRequest);
            }
            return ListOrganizationRecommendationResourcesPublisher.this.client.listOrganizationRecommendationResources((ListOrganizationRecommendationResourcesRequest)((Object)ListOrganizationRecommendationResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

