/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommendationPillar {
    COST_OPTIMIZING("cost_optimizing"),
    PERFORMANCE("performance"),
    SECURITY("security"),
    SERVICE_LIMITS("service_limits"),
    FAULT_TOLERANCE("fault_tolerance"),
    OPERATIONAL_EXCELLENCE("operational_excellence"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommendationPillar> VALUE_MAP;
    private final String value;

    private RecommendationPillar(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationPillar fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationPillar> knownValues() {
        EnumSet<RecommendationPillar> knownValues = EnumSet.allOf(RecommendationPillar.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommendationPillar.class, RecommendationPillar::toString);
    }
}

