/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorAsyncClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.CheckSummary;
import software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse;

public class ListChecksPublisher
implements SdkPublisher<ListChecksResponse> {
    private final TrustedAdvisorAsyncClient client;
    private final ListChecksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChecksPublisher(TrustedAdvisorAsyncClient client, ListChecksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChecksPublisher(TrustedAdvisorAsyncClient client, ListChecksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChecksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChecksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CheckSummary> checkSummaries() {
        Function<ListChecksResponse, Iterator> getIterator = response -> {
            if (response != null && response.checkSummaries() != null) {
                return response.checkSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListChecksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListChecksResponseFetcher
    implements AsyncPageFetcher<ListChecksResponse> {
        private ListChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListChecksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChecksResponse> nextPage(ListChecksResponse previousPage) {
            if (previousPage == null) {
                return ListChecksPublisher.this.client.listChecks(ListChecksPublisher.this.firstRequest);
            }
            return ListChecksPublisher.this.client.listChecks((ListChecksRequest)((Object)ListChecksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

