/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Language
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Language> {
    private static final SdkField<String> LANGUAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageName").getter(Language.getter(Language::languageName)).setter(Language.setter(Builder::languageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageName").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(Language.getter(Language::languageCode)).setter(Language.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_NAME_FIELD, LANGUAGE_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String languageName;
    private final String languageCode;

    private Language(BuilderImpl builder) {
        this.languageName = builder.languageName;
        this.languageCode = builder.languageCode;
    }

    public final String languageName() {
        return this.languageName;
    }

    public final String languageCode() {
        return this.languageCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Language)) {
            return false;
        }
        Language other = (Language)obj;
        return Objects.equals(this.languageName(), other.languageName()) && Objects.equals(this.languageCode(), other.languageCode());
    }

    public final String toString() {
        return ToString.builder((String)"Language").add("LanguageName", (Object)this.languageName()).add("LanguageCode", (Object)this.languageCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageName": {
                return Optional.ofNullable(clazz.cast(this.languageName()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Language, T> g) {
        return obj -> g.apply((Language)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageName;
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Language model) {
            this.languageName(model.languageName);
            this.languageCode(model.languageCode);
        }

        public final String getLanguageName() {
            return this.languageName;
        }

        public final void setLanguageName(String languageName) {
            this.languageName = languageName;
        }

        @Override
        public final Builder languageName(String languageName) {
            this.languageName = languageName;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public Language build() {
            return new Language(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Language> {
        public Builder languageName(String var1);

        public Builder languageCode(String var1);
    }
}

